/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.adridadou.ethereum.blockchain.Ethereumj;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.ethereum.core.Transaction;
import org.ethereum.facade.Blockchain;
import org.ethereum.facade.Ethereum;
import org.ethereum.listener.EthereumListener;

public class EthereumJReal
implements Ethereumj {
    private final Ethereum ethereum;

    public EthereumJReal(Ethereum ethereum) {
        this.ethereum = ethereum;
    }

    @Override
    public Blockchain getBlockchain() {
        return this.ethereum.getBlockchain();
    }

    @Override
    public void close() {
        this.ethereum.close();
    }

    @Override
    public long getGasPrice() {
        return this.ethereum.getGasPrice();
    }

    @Override
    public Future<Void> submitTransaction(Transaction tx) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.ethereum.submitTransaction(tx).get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public Transaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimitForConstantCalls, byte[] address, BigInteger value, byte[] data) {
        return this.ethereum.createTransaction(nonce, gasPrice, gasLimitForConstantCalls, address, value, data);
    }

    @Override
    public void addListener(EthereumEventHandler ethereumEventHandler) {
        this.ethereum.addListener((EthereumListener)ethereumEventHandler);
    }
}

