/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.adridadou.ethereum.blockchain.Ethereumj;
import org.adridadou.ethereum.blockchain.TestConfig;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.adridadou.ethereum.keystore.AccountProvider;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthValue;
import org.ethereum.config.BlockchainNetConfig;
import org.ethereum.config.Constants;
import org.ethereum.config.SystemProperties;
import org.ethereum.config.blockchain.FrontierConfig;
import org.ethereum.core.Transaction;
import org.ethereum.facade.Blockchain;
import org.ethereum.listener.EthereumListener;
import org.ethereum.util.blockchain.StandaloneBlockchain;

public class EthereumJTest
implements Ethereumj {
    private final StandaloneBlockchain blockchain;

    public EthereumJTest(TestConfig config) {
        SystemProperties.getDefault().setBlockchainConfig((BlockchainNetConfig)new FrontierConfig((Constants)new FrontierConfig.FrontierConstants(){

            public BigInteger getMINIMUM_DIFFICULTY() {
                return BigInteger.ONE;
            }
        }));
        this.blockchain = new StandaloneBlockchain();
        this.blockchain.withGasLimit(config.getGasLimit()).withGasPrice(config.getGasPrice());
        config.getBalances().entrySet().forEach(entry -> this.blockchain.withAccountBalance(((EthAccount)entry.getKey()).getAddress().address, ((EthValue)entry.getValue()).inWei()));
        this.blockchain.withCurrentTime(config.getInitialTime());
        this.blockchain.withAutoblock(true);
    }

    public EthAccount defaultAccount() {
        return AccountProvider.from(this.blockchain.getSender());
    }

    @Override
    public Blockchain getBlockchain() {
        return this.blockchain.getBlockchain();
    }

    @Override
    public void close() {
    }

    @Override
    public long getGasPrice() {
        return 0L;
    }

    @Override
    public Future<Void> submitTransaction(Transaction tx) {
        return CompletableFuture.runAsync(() -> this.blockchain.submitTransaction(tx));
    }

    @Override
    public Transaction createTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimitForConstantCalls, byte[] address, BigInteger value, byte[] data) {
        return this.blockchain.createTransaction(nonce.longValue(), address, value.longValue(), data);
    }

    @Override
    public void addListener(EthereumEventHandler ethereumEventHandler) {
        this.blockchain.addEthereumListener((EthereumListener)ethereumEventHandler);
    }
}

