/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.CompiledContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SmartContractByteCode;
import org.adridadou.exception.EthereumApiException;
import rx.Observable;

public interface EthereumProxy {
    public SmartContract mapFromAbi(ContractAbi var1, EthAddress var2, EthAccount var3);

    public CompletableFuture<EthAddress> publish(CompiledContract var1, EthAccount var2, Object ... var3);

    public CompletableFuture<EthExecutionResult> sendTx(EthValue var1, EthData var2, EthAccount var3, EthAddress var4);

    public CompletableFuture<EthAddress> sendTx(EthValue var1, EthData var2, EthAccount var3);

    public EthereumEventHandler events();

    public boolean addressExists(EthAddress var1);

    public EthValue getBalance(EthAddress var1);

    public BigInteger getNonce(EthAddress var1);

    public SmartContractByteCode getCode(EthAddress var1);

    default public void hasEnoughFund(EthAddress address, EthValue requiredFund) {
        if (this.getBalance(address).compareTo(requiredFund) < 0) {
            throw new EthereumApiException("not enough fund for " + address.withLeading0x());
        }
    }

    public <T> Observable<T> observeEvents(ContractAbi var1, EthAddress var2, String var3, Class<T> var4);

    public void shutdown();
}

