/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.adridadou.ethereum.blockchain.EthereumProxy;
import org.adridadou.ethereum.blockchain.Ethereumj;
import org.adridadou.ethereum.converters.input.InputTypeHandler;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.adridadou.ethereum.event.OnTransactionParameters;
import org.adridadou.ethereum.event.TransactionStatus;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractEthereumJ;
import org.adridadou.ethereum.values.CompiledContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SmartContractByteCode;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.Block;
import org.ethereum.core.BlockchainImpl;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Repository;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionExecutor;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.util.ByteUtil;
import org.ethereum.vm.LogInfo;
import rx.Observable;

public class EthereumProxyEthereumJ
implements EthereumProxy {
    public static final BigInteger GAS_LIMIT_FOR_CONSTANT_CALLS = BigInteger.valueOf(100000000000000L);
    private static final long BLOCK_WAIT_LIMIT = 16L;
    private final Ethereumj ethereum;
    private final EthereumEventHandler eventHandler;
    private final Map<EthAddress, BigInteger> pendingTransactions = new ConcurrentHashMap<EthAddress, BigInteger>();
    private final InputTypeHandler inputTypeHandler;
    private final OutputTypeHandler outputTypeHandler;

    public EthereumProxyEthereumJ(Ethereumj ethereum, EthereumEventHandler eventHandler, InputTypeHandler inputTypeHandler, OutputTypeHandler outputTypeHandler) {
        this.ethereum = ethereum;
        this.eventHandler = eventHandler;
        this.inputTypeHandler = inputTypeHandler;
        this.outputTypeHandler = outputTypeHandler;
        eventHandler.onReady().thenAccept(b -> this.getBlockchain().flush());
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, EthAccount sender) {
        return new SmartContractEthereumJ(new CallTransaction.Contract(abi.getAbi()), this.ethereum, sender, address, this);
    }

    @Override
    public CompletableFuture<EthAddress> publish(CompiledContract contract, EthAccount sender, Object ... constructorArgs) {
        return this.createContract(contract, sender, constructorArgs);
    }

    private CompletableFuture<EthAddress> createContract(CompiledContract contract, EthAccount sender, Object ... constructorArgs) {
        CallTransaction.Contract contractAbi = new CallTransaction.Contract(contract.getAbi().getAbi());
        CallTransaction.Function constructor = contractAbi.getConstructor();
        if (constructor == null && constructorArgs.length > 0) {
            throw new EthereumApiException("No constructor with params found");
        }
        byte[] argsEncoded = constructor == null ? new byte[]{} : constructor.encodeArguments(this.prepareArguments(constructorArgs));
        return this.sendTx(EthValue.wei(0), EthData.of(ByteUtil.merge((byte[][])new byte[][]{contract.getBinary().data, argsEncoded})), sender);
    }

    public Object[] prepareArguments(Object[] args) {
        return Arrays.stream(args).map(this.inputTypeHandler::convert).toArray();
    }

    @Override
    public BigInteger getNonce(EthAddress address) {
        BigInteger nonce = this.getBlockchain().getRepository().getNonce(address.address);
        return nonce.add(this.pendingTransactions.getOrDefault(address, BigInteger.ZERO));
    }

    @Override
    public SmartContractByteCode getCode(EthAddress address) {
        byte[] code = this.getRepository().getCode(address.address);
        if (code.length == 0) {
            throw new EthereumApiException("no code found at the address. please verify that a smart contract is deployed at " + address.withLeading0x());
        }
        return SmartContractByteCode.of(code);
    }

    @Override
    public <T> Observable<T> observeEvents(ContractAbi abi, EthAddress contractAddress, String eventName, Class<T> cls) {
        CallTransaction.Contract contract = new CallTransaction.Contract(abi.getAbi());
        return this.eventHandler.observeTransactions().filter(params -> params.receiver.equals(contractAddress)).flatMap(params -> Observable.from(params.logs)).map(arg_0 -> ((CallTransaction.Contract)contract).parseEvent(arg_0)).filter(invocation -> invocation != null && eventName.equals(invocation.function.name)).map(invocation -> this.outputTypeHandler.convertSpecificType(invocation.args, cls));
    }

    @Override
    public void shutdown() {
        this.ethereum.close();
    }

    @Override
    public CompletableFuture<EthAddress> sendTx(EthValue ethValue, EthData data, EthAccount sender) {
        return this.sendTxInternal(ethValue, data, sender, EthAddress.empty()).thenApply(receipt -> EthAddress.of(receipt.getTransaction().getContractAddress()));
    }

    @Override
    public CompletableFuture<EthExecutionResult> sendTx(EthValue value, EthData data, EthAccount sender, EthAddress address) {
        return this.sendTxInternal(value, data, sender, address).thenApply(receipt -> new EthExecutionResult(receipt.getExecutionResult()));
    }

    private CompletableFuture<TransactionReceipt> sendTxInternal(EthValue value, EthData data, EthAccount account, EthAddress toAddress) {
        return this.eventHandler.onReady().thenCompose(b -> {
            BigInteger nonce = this.getNonce(account.getAddress());
            Transaction txLocal = this.ethereum.createTransaction(nonce, BigInteger.valueOf(this.ethereum.getGasPrice()), GAS_LIMIT_FOR_CONSTANT_CALLS, toAddress.address, value.inWei(), data.data);
            txLocal.sign(account.key);
            BigInteger gasLimit = this.estimateGas(this.getBlockchain().getBestBlock(), txLocal).add(BigInteger.valueOf(100000L));
            Transaction tx = this.ethereum.createTransaction(nonce, BigInteger.valueOf(this.ethereum.getGasPrice()), gasLimit, toAddress.address, value.inWei(), data.data);
            tx.sign(account.key);
            long currentBlock = this.eventHandler.getCurrentBlockNumber();
            CompletableFuture<TransactionReceipt> result = CompletableFuture.supplyAsync(() -> {
                Observable droppedTxs = this.eventHandler.observeTransactions().filter(params -> Arrays.equals(params.txHash.data, tx.getHash()) && params.status == TransactionStatus.Dropped);
                Observable timeoutBlock = this.eventHandler.observeBlocks().filter(blockParams -> blockParams.block.getNumber() > currentBlock + 16L).map(params -> null);
                Observable blockTxs = this.eventHandler.observeBlocks().flatMap(params -> Observable.from(params.receipts)).filter(receipt -> Arrays.equals(receipt.getTransaction().getHash(), tx.getHash())).map(receipt -> new OnTransactionParameters((TransactionReceipt)receipt, EthData.of(receipt.getTransaction().getHash()), TransactionStatus.Executed, receipt.getError(), (List<LogInfo>)new ArrayList<LogInfo>(), receipt.getTransaction().getSender(), receipt.getTransaction().getReceiveAddress()));
                return (TransactionReceipt)Observable.merge((Observable)droppedTxs, (Observable)blockTxs, (Observable)timeoutBlock).map(params -> {
                    if (params == null) {
                        throw new EthereumApiException("the transaction has not been included in the last 16 blocks");
                    }
                    TransactionReceipt receipt = params.receipt;
                    this.decreasePendingTransactionCounter(account.getAddress());
                    if (params.status == TransactionStatus.Dropped) {
                        throw new EthereumApiException("the transaction has been dropped! - " + params.error);
                    }
                    return this.eventHandler.checkForErrors(receipt);
                }).toBlocking().first();
            });
            CompletableFuture<Void> submitTx = CompletableFuture.runAsync(() -> {
                try {
                    this.ethereum.submitTransaction(tx).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new EthereumApiException("error while submitting the transaction", e);
                }
            });
            this.increasePendingTransactionCounter(account.getAddress());
            return submitTx.thenCompose(txResult -> result);
        });
    }

    @Override
    public EthereumEventHandler events() {
        return this.eventHandler;
    }

    @Override
    public boolean addressExists(EthAddress address) {
        return this.getRepository().isExist(address.address);
    }

    @Override
    public EthValue getBalance(EthAddress address) {
        return EthValue.wei(this.getRepository().getBalance(address.address));
    }

    private void decreasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).subtract(BigInteger.ONE));
    }

    private void increasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).add(BigInteger.ONE));
    }

    protected void finalize() {
        this.ethereum.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigInteger estimateGas(Block callBlock, Transaction tx) {
        Repository repository = this.getRepository().getSnapshotTo(callBlock.getStateRoot()).startTracking();
        try {
            TransactionExecutor executor = new TransactionExecutor(tx, callBlock.getCoinbase(), repository, this.getBlockchain().getBlockStore(), this.getBlockchain().getProgramInvokeFactory(), callBlock).setLocalCall(true);
            executor.init();
            executor.execute();
            executor.go();
            executor.finalization();
            if (!executor.getReceipt().isSuccessful()) {
                throw new EthereumApiException(executor.getReceipt().getError());
            }
            long gasUsed = executor.getGasUsed();
            BigInteger bigInteger = BigInteger.valueOf(gasUsed);
            return bigInteger;
        }
        finally {
            repository.rollback();
        }
    }

    private BlockchainImpl getBlockchain() {
        return (BlockchainImpl)this.ethereum.getBlockchain();
    }

    private Repository getRepository() {
        return this.getBlockchain().getRepository();
    }
}

