/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.blockchain.EthereumProxy;
import org.adridadou.ethereum.blockchain.Web3JFacade;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractRpc;
import org.adridadou.ethereum.values.CompiledContract;
import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthExecutionResult;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.SmartContractByteCode;
import org.adridadou.ethereum.values.config.ChainId;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Transaction;
import org.ethereum.util.ByteUtil;
import org.ethereum.util.CopyOnWriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.core.methods.request.RawTransaction;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import rx.Observable;

public class EthereumProxyRpc
implements EthereumProxy {
    private static final Logger log = LoggerFactory.getLogger(EthereumProxyRpc.class);
    private final Map<EthAddress, BigInteger> pendingTransactions = new CopyOnWriteMap();
    private final ChainId chainId;
    private final Web3JFacade web3JFacade;

    public EthereumProxyRpc(Web3JFacade web3jFacade, ChainId chainId) {
        this.web3JFacade = web3jFacade;
        this.chainId = chainId;
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, EthAccount sender) {
        return new SmartContractRpc(abi.getAbi(), this.web3JFacade, sender, address, this);
    }

    @Override
    public CompletableFuture<EthAddress> publish(CompiledContract contract, EthAccount sender, Object ... constructorArgs) {
        return this.createContract(contract, sender, constructorArgs);
    }

    private CompletableFuture<EthAddress> createContract(CompiledContract compiledContract, EthAccount sender, Object ... constructorArgs) {
        CallTransaction.Contract contract = new CallTransaction.Contract(compiledContract.getAbi().getAbi());
        CallTransaction.Function constructor = contract.getConstructor();
        if (constructor == null && constructorArgs.length > 0) {
            throw new EthereumApiException("No constructor with params found");
        }
        byte[] argsEncoded = constructor == null ? new byte[]{} : constructor.encodeArguments(constructorArgs);
        return this.sendTx(EthValue.wei(0), EthData.of(ByteUtil.merge((byte[][])new byte[][]{compiledContract.getBinary().data, argsEncoded})), sender);
    }

    private CompletableFuture<TransactionReceipt> waitForTransactionReceipt(EthData transactionHash) {
        return CompletableFuture.supplyAsync(() -> this.getTransactionReceipt(transactionHash).orElseThrow(() -> new EthereumApiException("Transaction receipt not found!")));
    }

    private Optional<TransactionReceipt> getTransactionReceipt(EthData transactionHash) {
        this.web3JFacade.observeTransactionsFromBlock().filter(tx -> EthData.of(tx.getHash()).equals(transactionHash)).toBlocking().first();
        return Optional.ofNullable(this.web3JFacade.getTransactionReceipt(transactionHash));
    }

    @Override
    public CompletableFuture<EthExecutionResult> sendTx(EthValue value, EthData data, EthAccount account, EthAddress toAddress) {
        BigInteger gasPrice = this.web3JFacade.getGasPrice();
        BigInteger gasLimit = this.web3JFacade.estimateGas(account, data);
        this.increasePendingTransactionCounter(account.getAddress());
        Transaction tx = new Transaction(ByteUtil.bigIntegerToBytes((BigInteger)this.getNonce(account.getAddress())), ByteUtil.longToBytesNoLeadZeroes((long)gasPrice.longValue()), ByteUtil.longToBytesNoLeadZeroes((long)gasLimit.longValue()), (byte[])Optional.ofNullable(toAddress).map(addr -> addr.address).orElse(null), ByteUtil.longToBytesNoLeadZeroes((long)value.inWei().longValue()), data.data, Byte.valueOf((byte)this.chainId.id));
        tx.sign(account.key);
        return CompletableFuture.supplyAsync(() -> {
            this.web3JFacade.sendTransaction(EthData.of(tx.getEncoded()));
            this.decreasePendingTransactionCounter(account.getAddress());
            return new EthExecutionResult(new byte[0]);
        });
    }

    @Override
    public BigInteger getNonce(EthAddress address) {
        return this.web3JFacade.getTransactionCount(address).add(this.pendingTransactions.getOrDefault(address, BigInteger.ZERO)).subtract(BigInteger.ONE);
    }

    @Override
    public SmartContractByteCode getCode(EthAddress address) {
        return this.web3JFacade.getCode(address);
    }

    @Override
    public <T> Observable<T> observeEvents(ContractAbi abi, EthAddress contractAddress, String eventName, Class<T> cls) {
        return this.web3JFacade.event(contractAddress, eventName, new CallTransaction.Contract(abi.getAbi()), cls);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public CompletableFuture<EthAddress> sendTx(EthValue ethValue, EthData data, EthAccount sender) {
        BigInteger gasPrice = this.web3JFacade.getGasPrice();
        BigInteger gasLimit = this.web3JFacade.estimateGas(sender, data);
        this.increasePendingTransactionCounter(sender.getAddress());
        RawTransaction tx = RawTransaction.createContractTransaction((BigInteger)this.getNonce(sender.getAddress()), (BigInteger)gasPrice, (BigInteger)gasLimit, (BigInteger)ethValue.inWei(), (String)data.toString());
        EthData signedTx = EthData.of(TransactionEncoder.signMessage((RawTransaction)tx, (Credentials)sender.credentials));
        EthData result = this.web3JFacade.sendTransaction(signedTx);
        return this.handleTransaction(result).thenApply(receipt -> {
            this.decreasePendingTransactionCounter(sender.getAddress());
            return EthAddress.of(receipt.getContractAddress().orElse(null));
        });
    }

    private CompletableFuture<TransactionReceipt> handleTransaction(EthData result) {
        log.info("transaction " + result.toString() + " has been sent. Waiting to be mined");
        return this.waitForTransactionReceipt(result);
    }

    @Override
    public EthereumEventHandler events() {
        throw new EthereumApiException("event handling is not yet implemented for RPC");
    }

    @Override
    public boolean addressExists(EthAddress address) {
        throw new EthereumApiException("addressExists is not implemented for RPC");
    }

    @Override
    public EthValue getBalance(EthAddress address) {
        EthGetBalance result = this.web3JFacade.getBalance(address);
        if (result.hasError()) {
            throw new EthereumApiException(result.getError().getMessage());
        }
        return EthValue.wei(result.getBalance());
    }

    private void decreasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).subtract(BigInteger.ONE));
    }

    private void increasePendingTransactionCounter(EthAddress address) {
        this.pendingTransactions.put(address, this.pendingTransactions.getOrDefault(address, BigInteger.ZERO).add(BigInteger.ONE));
    }
}

