/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.blockchain;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthValue;

public class TestConfig {
    private final Date initialTime;
    private final long gasLimit;
    private final long gasPrice;
    private final Map<EthAccount, EthValue> balances;

    public TestConfig(Date initialTime, long gasLimit, long gasPrice, Map<EthAccount, EthValue> balances) {
        this.initialTime = initialTime;
        this.gasLimit = gasLimit;
        this.gasPrice = gasPrice;
        this.balances = balances;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public long getGasPrice() {
        return this.gasPrice;
    }

    public Map<EthAccount, EthValue> getBalances() {
        return this.balances;
    }

    public Date getInitialTime() {
        return this.initialTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long gasLimit = 4700000L;
        private long gasPrice = 0L;
        private final Map<EthAccount, EthValue> balances = new HashMap<EthAccount, EthValue>();
        private Date initialTime = new Date();

        public Builder gasLimit(long gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        public Builder gasPrice(long gasPrice) {
            this.gasPrice = gasPrice;
            return this;
        }

        public Builder balance(EthAccount account, EthValue value) {
            this.balances.put(account, value);
            return this;
        }

        public Builder initialTime(Date date) {
            this.initialTime = date;
            return this;
        }

        public TestConfig build() {
            return new TestConfig(this.initialTime, this.gasLimit, this.gasPrice, this.balances);
        }
    }
}

