/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.converters.output;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.adridadou.ethereum.converters.output.AddressConverter;
import org.adridadou.ethereum.converters.output.ArrayConverter;
import org.adridadou.ethereum.converters.output.BigIntegerConverter;
import org.adridadou.ethereum.converters.output.BooleanConverter;
import org.adridadou.ethereum.converters.output.CompletableFutureConverter;
import org.adridadou.ethereum.converters.output.DateConverter;
import org.adridadou.ethereum.converters.output.EnumConverter;
import org.adridadou.ethereum.converters.output.IntegerConverter;
import org.adridadou.ethereum.converters.output.ListConverter;
import org.adridadou.ethereum.converters.output.LongConverter;
import org.adridadou.ethereum.converters.output.OutputTypeConverter;
import org.adridadou.ethereum.converters.output.PayableConverter;
import org.adridadou.ethereum.converters.output.SetConverter;
import org.adridadou.ethereum.converters.output.StringConverter;
import org.adridadou.ethereum.converters.output.VoidConverter;
import org.adridadou.exception.EthereumApiException;

public class OutputTypeHandler {
    public static final List<OutputTypeConverter> JAVA_OUTPUT_CONVERTERS = ImmutableList.builder().add((Object[])new OutputTypeConverter[]{new IntegerConverter(), new LongConverter(), new StringConverter(), new BooleanConverter(), new AddressConverter(), new VoidConverter(), new EnumConverter(), new DateConverter(), new BigIntegerConverter()}).build();
    private final List<OutputTypeConverter> outputConverters = new ArrayList<OutputTypeConverter>();

    public OutputTypeHandler() {
        this.addConverters(JAVA_OUTPUT_CONVERTERS);
        this.addConverters(new ListConverter(this), new ArrayConverter(this), new CompletableFutureConverter(this), new PayableConverter(this), new SetConverter(this));
    }

    public void addConverters(OutputTypeConverter ... converters) {
        this.addConverters(Lists.newArrayList((Object[])converters));
    }

    public void addConverters(Collection<OutputTypeConverter> converters) {
        this.outputConverters.addAll(converters);
    }

    public Optional<OutputTypeConverter> getConverter(Class<?> cls) {
        return this.outputConverters.stream().filter(converter -> converter.isOfType(cls)).findFirst();
    }

    public <T> T convertSpecificType(Object[] result, Class<T> returnType) {
        Object[] params = new Object[result.length];
        Constructor constr = this.lookForNonEmptyConstructor(returnType, result);
        for (int i = 0; i < result.length; ++i) {
            params[i] = this.convertResult(result[i], constr.getParameterTypes()[i], constr.getGenericParameterTypes()[i]);
        }
        try {
            return constr.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new EthereumApiException("error while converting to a specific type", e);
        }
    }

    private Constructor lookForNonEmptyConstructor(Class<?> returnType, Object[] result) {
        for (Constructor<?> constructor : returnType.getConstructors()) {
            if (constructor.getParameterCount() <= 0) continue;
            if (constructor.getParameterCount() != result.length) {
                throw new IllegalArgumentException("the number of arguments don't match for type " + returnType.getSimpleName() + ". Constructor has " + constructor.getParameterCount() + " and result has " + result.length);
            }
            return constructor;
        }
        throw new IllegalArgumentException("no constructor with arguments found! for type " + returnType.getSimpleName());
    }

    public Object convertResult(Object result, Class<?> returnType, Type genericType) {
        return this.getConverter(returnType).map(converter -> converter.convert(result, returnType.isArray() ? returnType.getComponentType() : genericType)).orElseGet(() -> this.convertSpecificType(new Object[]{result}, returnType));
    }
}

