/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.blockchain.Ethereumj;
import org.adridadou.ethereum.event.OnBlockHandler;
import org.adridadou.ethereum.event.OnBlockParameters;
import org.adridadou.ethereum.event.OnTransactionHandler;
import org.adridadou.ethereum.event.OnTransactionParameters;
import org.adridadou.ethereum.event.TransactionStatus;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.Block;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionExecutionSummary;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.listener.EthereumListener;
import org.ethereum.listener.EthereumListenerAdapter;
import org.ethereum.vm.LogInfo;
import org.spongycastle.util.encoders.Hex;
import rx.Observable;

public class EthereumEventHandler
extends EthereumListenerAdapter {
    private final CompletableFuture<Boolean> ready = new CompletableFuture();
    private final OnBlockHandler onBlockHandler;
    private final OnTransactionHandler onTransactionHandler;
    private long currentBlockNumber;

    public EthereumEventHandler(Ethereumj ethereum) {
        ethereum.addListener(this);
        this.onBlockHandler = new OnBlockHandler();
        this.onTransactionHandler = new OnTransactionHandler();
        this.currentBlockNumber = ethereum.getBlockchain().getBestBlock().getNumber();
    }

    public void onBlock(Block block, List<TransactionReceipt> receipts) {
        this.onBlockHandler.newBlock(new OnBlockParameters(block, receipts));
        this.currentBlockNumber = block.getNumber();
    }

    public void onPendingTransactionUpdate(TransactionReceipt txReceipt, EthereumListener.PendingTransactionState state, Block block) {
        TransactionStatus transactionStatus = null;
        switch (state) {
            case PENDING: 
            case NEW_PENDING: {
                transactionStatus = TransactionStatus.Pending;
                break;
            }
            case DROPPED: {
                transactionStatus = TransactionStatus.Dropped;
                break;
            }
            case INCLUDED: {
                transactionStatus = TransactionStatus.Included;
            }
        }
        Transaction transaction = txReceipt.getTransaction();
        this.onTransactionHandler.on(new OnTransactionParameters(txReceipt, EthData.of(transaction.getHash()), transactionStatus, txReceipt.getError(), new ArrayList<LogInfo>(), transaction.getSender(), transaction.getReceiveAddress()));
    }

    public void onTransactionExecuted(TransactionExecutionSummary summary) {
        summary.getInternalTransactions().forEach(internalTransaction -> this.onTransactionHandler.on(new OnTransactionParameters(null, EthData.of(internalTransaction.getHash()), TransactionStatus.Executed, "", summary.getLogs(), internalTransaction.getSender(), internalTransaction.getReceiveAddress())));
        Transaction transaction = summary.getTransaction();
        this.onTransactionHandler.on(new OnTransactionParameters(null, EthData.of(transaction.getHash()), TransactionStatus.Executed, "", summary.getLogs(), transaction.getSender(), transaction.getReceiveAddress()));
    }

    public TransactionReceipt checkForErrors(TransactionReceipt receipt) {
        if (receipt.isSuccessful() && receipt.isValid()) {
            return receipt;
        }
        throw new EthereumApiException("error with the transaction " + Hex.toHexString((byte[])receipt.getTransaction().getHash()) + ". error:" + receipt.getError());
    }

    public void onSyncDone(EthereumListener.SyncState syncState) {
        this.ready.complete(Boolean.TRUE);
    }

    public CompletableFuture<Boolean> onReady() {
        return this.ready;
    }

    public long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    public Observable<OnBlockParameters> observeBlocks() {
        return this.onBlockHandler.observable;
    }

    public Observable<OnTransactionParameters> observeTransactions() {
        return this.onTransactionHandler.observable;
    }
}

