/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.event;

import java.util.List;
import java.util.Optional;
import org.adridadou.ethereum.event.TransactionStatus;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.vm.LogInfo;

public class OnTransactionParameters {
    public final TransactionReceipt receipt;
    public final EthData txHash;
    public final TransactionStatus status;
    public final String error;
    public final List<LogInfo> logs;
    public final EthAddress sender;
    public final EthAddress receiver;
    public final Boolean isContractCreation;

    public OnTransactionParameters(TransactionReceipt receipt, EthData txHash, TransactionStatus status, String error, List<LogInfo> logs, byte[] sender, byte[] receiver) {
        this.receipt = receipt;
        this.txHash = txHash;
        this.status = status;
        this.error = error;
        this.logs = logs;
        this.sender = EthAddress.of(sender);
        this.receiver = Optional.ofNullable(receiver).map(EthAddress::of).orElse(EthAddress.empty());
        this.isContractCreation = this.receiver == null || this.receiver.isEmpty();
    }

    public String toString() {
        return "OnTransactionParameters{receipt=" + this.receipt + ", txHash=" + this.txHash + ", status=" + (Object)((Object)this.status) + ", error='" + this.error + '\'' + ", logs=" + this.logs + ", sender=" + this.sender + ", receiver=" + this.receiver + ", isContractCreation=" + this.isContractCreation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnTransactionParameters that = (OnTransactionParameters)o;
        if (this.receipt != null ? !this.receipt.equals(that.receipt) : that.receipt != null) {
            return false;
        }
        if (this.txHash != null ? !this.txHash.equals(that.txHash) : that.txHash != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        if (this.logs != null ? !this.logs.equals(that.logs) : that.logs != null) {
            return false;
        }
        if (this.sender != null ? !this.sender.equals(that.sender) : that.sender != null) {
            return false;
        }
        if (this.receiver != null ? !this.receiver.equals(that.receiver) : that.receiver != null) {
            return false;
        }
        return this.isContractCreation != null ? this.isContractCreation.equals(that.isContractCreation) : that.isContractCreation == null;
    }

    public int hashCode() {
        int result = this.receipt != null ? this.receipt.hashCode() : 0;
        result = 31 * result + (this.txHash != null ? this.txHash.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.error != null ? this.error.hashCode() : 0);
        result = 31 * result + (this.logs != null ? this.logs.hashCode() : 0);
        result = 31 * result + (this.sender != null ? this.sender.hashCode() : 0);
        result = 31 * result + (this.receiver != null ? this.receiver.hashCode() : 0);
        result = 31 * result + (this.isContractCreation != null ? this.isContractCreation.hashCode() : 0);
        return result;
    }
}

