/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.keystore;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.keystore.FileSecureKey;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.crypto.ECKey;
import org.spongycastle.crypto.digests.SHA3Digest;
import org.spongycastle.util.encoders.Hex;
import org.web3j.crypto.WalletUtils;

public class AccountProvider {
    public static EthAccount fromPrivateKey(byte[] privateKey) {
        return new EthAccount(ECKey.fromPrivate((byte[])privateKey));
    }

    public static EthAccount fromPrivateKey(String privateKey) {
        return new EthAccount(ECKey.fromPrivate((byte[])Hex.decode((String)privateKey)));
    }

    public static EthAccount from(ECKey ecKey) {
        return new EthAccount(ecKey);
    }

    public static EthAccount from(String id) {
        return new EthAccount(ECKey.fromPrivate((byte[])AccountProvider.doSha3(id.getBytes(EthereumFacade.CHARSET))));
    }

    public static SecureKey from(File file) {
        return new FileSecureKey(file);
    }

    public static List<SecureKey> listMainKeystores() {
        return AccountProvider.listKeystores(new File(WalletUtils.getMainnetKeyDirectory()));
    }

    public static List<SecureKey> listRopstenKeystores() {
        return AccountProvider.listKeystores(new File(WalletUtils.getTestnetKeyDirectory()));
    }

    public static List<SecureKey> listKeystores(File directory) {
        Object[] files = Optional.ofNullable(directory.listFiles()).orElseThrow(() -> new EthereumApiException("cannot find the folder " + WalletUtils.getMainnetKeyDirectory()));
        return Lists.newArrayList((Object[])files).stream().filter(File::isFile).map(AccountProvider::from).collect(Collectors.toList());
    }

    private static byte[] doSha3(byte[] message) {
        SHA3Digest digest = new SHA3Digest(256);
        byte[] hash = new byte[digest.getDigestSize()];
        if (message.length != 0) {
            digest.update(message, 0, message.length);
        }
        digest.doFinal(hash, 0);
        return hash;
    }
}

