/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.keystore;

import java.io.File;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.keystore.KdfParams;
import org.adridadou.ethereum.keystore.KeystoreCrypto;
import org.adridadou.exception.EthereumApiException;
import org.codehaus.jackson.annotate.JsonSetter;
import org.codehaus.jackson.map.ObjectMapper;
import org.ethereum.crypto.ECKey;
import org.spongycastle.crypto.generators.SCrypt;
import org.spongycastle.jcajce.provider.digest.Keccak;
import org.spongycastle.util.encoders.Hex;

public class Keystore {
    private KeystoreCrypto crypto;
    private String id;
    private Integer version;
    private String address;

    public static ECKey fromKeystore(File keystore, String password) throws Exception {
        byte[] cipherKey;
        ObjectMapper mapper = new ObjectMapper();
        Keystore ksObj = (Keystore)mapper.readValue(keystore, Keystore.class);
        switch (ksObj.getCrypto().getKdf()) {
            case "pbkdf2": {
                cipherKey = Keystore.checkMacSha3(ksObj, password);
                break;
            }
            case "scrypt": {
                cipherKey = Keystore.checkMacScrypt(ksObj, password);
                break;
            }
            default: {
                throw new EthereumApiException("non valid algorithm " + ksObj.getCrypto().getCipher());
            }
        }
        byte[] secret = Keystore.decryptAes(Hex.decode((String)ksObj.getCrypto().getCipherparams().getIv()), cipherKey, Hex.decode((String)ksObj.getCrypto().getCiphertext()));
        return ECKey.fromPrivate((byte[])secret);
    }

    private static byte[] decryptAes(byte[] iv, byte[] keyBytes, byte[] cipherText) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance("AES/CTR/NoPadding");
        cipher.init(2, (Key)key, ivSpec);
        return cipher.doFinal(cipherText);
    }

    private static byte[] checkMacSha3(Keystore keystore, String password) throws Exception {
        byte[] salt = Hex.decode((String)keystore.getCrypto().getKdfparams().getSalt());
        int iterations = keystore.getCrypto().getKdfparams().getC();
        byte[] part = new byte[16];
        byte[] h = Keystore.hash(password, salt, iterations);
        byte[] cipherText = Hex.decode((String)keystore.getCrypto().getCiphertext());
        System.arraycopy(h, 16, part, 0, 16);
        byte[] actual = Keystore.sha3(Keystore.concat(part, cipherText));
        if (Arrays.equals(actual, Hex.decode((String)keystore.getCrypto().getMac()))) {
            System.arraycopy(h, 0, part, 0, 16);
            return part;
        }
        throw new EthereumApiException("error while loading the private key forNetwork the keystore. Most probably a wrong passphrase");
    }

    private static byte[] checkMacScrypt(Keystore keystore, String password) {
        byte[] part = new byte[16];
        KdfParams params = keystore.getCrypto().getKdfparams();
        byte[] h = Keystore.scrypt(password.getBytes(EthereumFacade.CHARSET), Hex.decode((String)params.getSalt()), params.getN(), params.getR(), params.getP(), params.getDklen());
        byte[] cipherText = Hex.decode((String)keystore.getCrypto().getCiphertext());
        System.arraycopy(h, 16, part, 0, 16);
        byte[] actual = Keystore.sha3(Keystore.concat(part, cipherText));
        if (Arrays.equals(actual, Hex.decode((String)keystore.getCrypto().getMac()))) {
            System.arraycopy(h, 0, part, 0, 16);
            return part;
        }
        throw new EthereumApiException("error while loading the private key forNetwork the keystore. Most probably a wrong passphrase");
    }

    private static byte[] concat(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] c = new byte[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    private static byte[] scrypt(byte[] pass, byte[] salt, int n, int r, int p, int dkLen) {
        return SCrypt.generate((byte[])pass, (byte[])salt, (int)n, (int)r, (int)p, (int)dkLen);
    }

    private static byte[] hash(String encryptedData, byte[] salt, int iterations) throws Exception {
        char[] chars = encryptedData.toCharArray();
        PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 256);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        return skf.generateSecret(spec).getEncoded();
    }

    public static byte[] sha3(byte[] h) {
        Keccak.Digest256 KECCAK = new Keccak.Digest256();
        KECCAK.reset();
        KECCAK.update(h);
        return KECCAK.digest();
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public KeystoreCrypto getCrypto() {
        return this.crypto;
    }

    @JsonSetter(value="crypto")
    public void setCrypto(KeystoreCrypto crypto) {
        this.crypto = crypto;
    }

    @JsonSetter(value="Crypto")
    public void setCryptoOld(KeystoreCrypto crypto) {
        this.crypto = crypto;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }
}

