/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.blockchain.EthereumJReal;
import org.adridadou.ethereum.blockchain.EthereumProxyEthereumJ;
import org.adridadou.ethereum.converters.input.InputTypeHandler;
import org.adridadou.ethereum.converters.output.OutputTypeHandler;
import org.adridadou.ethereum.event.EthereumEventHandler;
import org.adridadou.ethereum.keystore.AccountProvider;
import org.adridadou.ethereum.provider.EthereumJConfigs;
import org.adridadou.ethereum.provider.PrivateNetworkConfig;
import org.adridadou.ethereum.swarm.SwarmService;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.ethereum.values.config.DatabaseDirectory;
import org.adridadou.exception.EthereumApiException;
import org.apache.commons.io.FileUtils;
import org.ethereum.config.SystemProperties;
import org.ethereum.core.Block;
import org.ethereum.facade.Ethereum;
import org.ethereum.facade.EthereumFactory;
import org.ethereum.listener.EthereumListener;
import org.ethereum.mine.Ethash;
import org.ethereum.mine.MinerListener;
import org.ethereum.samples.BasicSample;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

public class PrivateEthereumFacadeProvider {
    private final Logger log = LoggerFactory.getLogger(PrivateEthereumFacadeProvider.class);
    private final EthAccount mainAccount = AccountProvider.from("cow");

    public EthereumFacade create(PrivateNetworkConfig config) {
        boolean dagCached = new File("cachedDag/mine-dag.dat").exists();
        if (config.isResetPrivateBlockchain()) {
            this.deleteFolder(new File(config.getDbName()), true);
        }
        if (dagCached) {
            new File(config.getDbName()).mkdirs();
            try {
                FileUtils.copyFile((File)new File("cachedDag/mine-dag.dat"), (File)new File(config.getDbName() + "/mine-dag.dat"));
                FileUtils.copyFile((File)new File("cachedDag/mine-dag-light.dat"), (File)new File(config.getDbName() + "/mine-dag-light.dat"));
            }
            catch (IOException e) {
                throw new EthereumApiException("error while copying dag files", e);
            }
        }
        MinerConfig.dbName = config.getDbName();
        Ethereum ethereum = EthereumFactory.createEthereum(MinerConfig.class);
        EthereumJReal ethereumj = new EthereumJReal(ethereum);
        ethereum.initSyncing();
        if (!dagCached) {
            try {
                new File("cachedDag").mkdirs();
                FileUtils.copyFile((File)new File(config.getDbName() + "/mine-dag.dat"), (File)new File("cachedDag/mine-dag.dat"));
                FileUtils.copyFile((File)new File(config.getDbName() + "/mine-dag-light.dat"), (File)new File("cachedDag/mine-dag-light.dat"));
            }
            catch (IOException e) {
                this.log.warn("couldn't copy files: " + e.getMessage());
            }
        }
        EthereumEventHandler ethereumListener = new EthereumEventHandler(ethereumj);
        InputTypeHandler inputTypeHandler = new InputTypeHandler();
        OutputTypeHandler outputTypeHandler = new OutputTypeHandler();
        EthereumFacade facade = new EthereumFacade(new EthereumProxyEthereumJ(ethereumj, ethereumListener, inputTypeHandler, outputTypeHandler), inputTypeHandler, outputTypeHandler, SwarmService.from("http://swarm-gateways.net"), SolidityCompiler.getInstance());
        ethereumListener.onSyncDone(EthereumListener.SyncState.COMPLETE);
        facade.events().onReady().thenAccept(b -> config.getInitialBalances().entrySet().stream().map(entry -> facade.sendEther(this.mainAccount, ((EthAccount)entry.getKey()).getAddress(), (EthValue)entry.getValue())).forEach(result -> {
            try {
                result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new EthereumApiException("error while setting the initial balances");
            }
        }));
        return facade;
    }

    private void deleteFolder(File folder, boolean root) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f, false);
                    continue;
                }
                f.delete();
            }
        }
        if (!root) {
            folder.delete();
        }
    }

    static class MinerNode
    extends BasicSample
    implements MinerListener {
        public MinerNode() {
            super("sampleMiner");
        }

        public void run() {
            if (this.config.isMineFullDataset()) {
                this.logger.info("Generating Full Dataset (may take up to 10 min if not cached)...");
                Ethash ethash = Ethash.getForBlock((SystemProperties)this.config, (long)this.ethereum.getBlockchain().getBestBlock().getNumber());
                ethash.getFullDataset();
                this.logger.info("Full dataset generated (loaded).");
            }
            this.ethereum.getBlockMiner().addListener((MinerListener)this);
            this.ethereum.getBlockMiner().startMining();
        }

        public void miningStarted() {
            this.logger.info("Miner started");
        }

        public void miningStopped() {
            this.logger.info("Miner stopped");
        }

        public void blockMiningStarted(Block block) {
            this.logger.info("Start mining block: " + block.getShortDescr());
        }

        public void blockMined(Block block) {
            this.logger.info("Block mined! : \n" + block);
        }

        public void blockMiningCanceled(Block block) {
            this.logger.info("Cancel mining block: " + block.getShortDescr());
        }
    }

    private static class MinerConfig {
        public static String dbName = "sampleDB";

        private MinerConfig() {
        }

        public static String config() {
            return EthereumJConfigs.privateMiner().dbDirectory(DatabaseDirectory.db(dbName)).listenPort(55555).build().toString();
        }

        @Bean
        public MinerNode node() {
            return new MinerNode();
        }

        @Bean
        public SystemProperties systemProperties() {
            SystemProperties props = new SystemProperties(ConfigFactory.empty(), PrivateEthereumFacadeProvider.class.getClassLoader());
            props.overrideParams(ConfigFactory.parseString((String)MinerConfig.config().replaceAll("'", "\"")));
            return props;
        }
    }
}

