/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.smartcontract;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.adridadou.ethereum.blockchain.EthereumProxyEthereumJ;
import org.adridadou.ethereum.blockchain.Ethereumj;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.EthAccount;
import org.adridadou.ethereum.values.EthAddress;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.EthValue;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.Block;
import org.ethereum.core.BlockchainImpl;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Repository;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionExecutor;

public class SmartContractEthereumJ
implements SmartContract {
    public static final long GAS_LIMIT_FOR_CONSTANT_CALLS = 100000000000000L;
    private final EthAddress address;
    private final CallTransaction.Contract contract;
    private final Ethereumj ethereum;
    private final EthereumProxyEthereumJ bcProxy;
    private final EthAccount sender;

    public SmartContractEthereumJ(CallTransaction.Contract contract, Ethereumj ethereum, EthAccount sender, EthAddress address, EthereumProxyEthereumJ bcProxy) {
        this.contract = contract;
        this.ethereum = ethereum;
        this.sender = sender;
        this.bcProxy = bcProxy;
        this.address = address;
    }

    @Override
    public List<CallTransaction.Function> getFunctions() {
        return Lists.newArrayList((Object[])this.contract.functions);
    }

    public Object[] callConstFunction(Block callBlock, String functionName, Object ... args) {
        TransactionExecutor executor = this.executeLocally(callBlock, functionName, args);
        if (!executor.getReceipt().isSuccessful()) {
            throw new EthereumApiException(executor.getReceipt().getError());
        }
        return this.contract.getByName(functionName).decodeResult(executor.getResult().getHReturn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionExecutor executeLocally(Block callBlock, String functionName, Object ... args) {
        Transaction tx = CallTransaction.createCallTransaction((long)0L, (long)0L, (long)100000000000000L, (String)this.address.toString(), (long)0L, (CallTransaction.Function)this.contract.getByName(functionName), (Object[])args);
        tx.sign(this.sender.key);
        Repository repository = this.getRepository().getSnapshotTo(callBlock.getStateRoot()).startTracking();
        try {
            TransactionExecutor executor = new TransactionExecutor(tx, callBlock.getCoinbase(), repository, this.getBlockchain().getBlockStore(), this.getBlockchain().getProgramInvokeFactory(), callBlock).setLocalCall(true);
            executor.init();
            executor.execute();
            executor.go();
            executor.finalization();
            TransactionExecutor transactionExecutor = executor;
            return transactionExecutor;
        }
        finally {
            repository.rollback();
        }
    }

    private BlockchainImpl getBlockchain() {
        return (BlockchainImpl)this.ethereum.getBlockchain();
    }

    private Repository getRepository() {
        return this.getBlockchain().getRepository();
    }

    @Override
    public CompletableFuture<Object[]> callFunction(String functionName, Object ... args) {
        return this.callFunction(EthValue.wei(0), functionName, args);
    }

    @Override
    public CompletableFuture<Object[]> callFunction(String functionName, EthValue value, Object ... arguments) {
        return this.callFunction(value, functionName, arguments);
    }

    public CompletableFuture<Object[]> callFunction(EthValue value, String functionName, Object ... args) {
        return Optional.ofNullable(this.contract.getByName(functionName)).map(func -> {
            EthData functionCallBytes = EthData.of(func.encode(args));
            return this.bcProxy.sendTx(value, functionCallBytes, this.sender, this.address).thenApply(receipt -> this.contract.getByName(functionName).decodeResult(receipt.getResult()));
        }).orElseThrow(() -> new EthereumApiException("function " + functionName + " cannot be found. available:" + this.getAvailableFunctions()));
    }

    private String getAvailableFunctions() {
        return Arrays.stream(this.contract.functions).map(c -> c.name).collect(Collectors.toList()).toString();
    }

    @Override
    public Object[] callConstFunction(String functionName, Object ... args) {
        return this.callConstFunction(this.getBlockchain().getBestBlock(), functionName, args);
    }

    public EthAddress getAddress() {
        return this.address;
    }
}

