/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.swarm;

import java.io.IOException;
import org.adridadou.ethereum.swarm.SwarmHash;
import org.adridadou.ethereum.values.smartcontract.SmartContractMetadata;
import org.adridadou.exception.EthereumApiException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SwarmService {
    public static final String PUBLIC_HOST = "http://swarm-gateways.net";
    private final String host;

    public SwarmService(String host) {
        this.host = host;
    }

    public static SwarmService from(String host) {
        return new SwarmService(host);
    }

    public SwarmHash publish(String content) {
        try {
            Response response = Request.Post((String)(this.host + "/bzzr:/")).bodyString(content, ContentType.TEXT_PLAIN).execute();
            return SwarmHash.of(response.returnContent().asString());
        }
        catch (IOException e) {
            throw new EthereumApiException("error while publishing the smart contract metadata to Swarm", e);
        }
    }

    public String get(SwarmHash hash) throws IOException {
        Response response = Request.Get((String)(this.host + "/bzzr:/" + hash.toString())).execute();
        return response.returnContent().asString();
    }

    public SmartContractMetadata getMetadata(SwarmHash hash) throws IOException {
        String metadata = this.get(hash);
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = (JSONObject)parser.parse(metadata);
            return new SmartContractMetadata(((JSONObject)json.get((Object)"output")).get((Object)"abi").toString());
        }
        catch (ParseException e) {
            throw new EthereumApiException("error while parsing metadata", e);
        }
    }
}

