/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import org.adridadou.ethereum.values.ContractAbi;
import org.adridadou.ethereum.values.ContractMetadata;
import org.adridadou.ethereum.values.EthData;
import org.adridadou.ethereum.values.SoliditySource;
import org.ethereum.solidity.compiler.CompilationResult;

public class CompiledContract {
    private final ContractAbi abi;
    private final EthData binary;
    private final ContractMetadata metadata;
    private final SoliditySource source;
    private final String name;

    public CompiledContract(ContractAbi abi, EthData binary, ContractMetadata metadata, SoliditySource source, String name) {
        this.abi = abi;
        this.binary = binary;
        this.metadata = metadata;
        this.source = source;
        this.name = name;
    }

    public ContractAbi getAbi() {
        return this.abi;
    }

    public EthData getBinary() {
        return this.binary;
    }

    public ContractMetadata getMetadata() {
        return this.metadata;
    }

    public SoliditySource getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public static CompiledContract from(SoliditySource src, String contractName, CompilationResult.ContractMetadata metadata) {
        return new CompiledContract(ContractAbi.of(metadata.abi), EthData.of(metadata.bin), new ContractMetadata(metadata.metadata), src, contractName);
    }
}

