/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.ethereum.crypto.ECKey;
import org.ethereum.util.ByteUtil;
import org.spongycastle.util.encoders.Hex;

public class EthAddress {
    public final byte[] address;

    private EthAddress(byte[] address) {
        Preconditions.checkArgument((address.length <= 32 ? 1 : 0) != 0, (Object)("byte array of the address cannot be bigger than 32.value:" + Hex.toHexString((byte[])address)));
        this.address = address;
    }

    public static EthAddress of(byte[] address) {
        return new EthAddress(EthAddress.trimLeft(address));
    }

    public static EthAddress of(ECKey key) {
        return new EthAddress(EthAddress.trimLeft(key.getAddress()));
    }

    private static byte[] trimLeft(byte[] address) {
        int firstNonZeroPos;
        for (firstNonZeroPos = 0; firstNonZeroPos < address.length && address[firstNonZeroPos] == 0; ++firstNonZeroPos) {
        }
        byte[] newAddress = new byte[address.length - firstNonZeroPos];
        System.arraycopy(address, firstNonZeroPos, newAddress, 0, address.length - firstNonZeroPos);
        return newAddress;
    }

    public static EthAddress of(String address) {
        if (address != null && address.startsWith("0x")) {
            return EthAddress.of(Hex.decode((String)address.substring(2)));
        }
        return EthAddress.of(Hex.decode((String)address));
    }

    public String toString() {
        return Hex.toHexString((byte[])this.address);
    }

    public String withLeading0x() {
        return "0x" + this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthAddress that = (EthAddress)o;
        return Arrays.equals(this.address, that.address);
    }

    public int hashCode() {
        return Arrays.hashCode(this.address);
    }

    public static EthAddress empty() {
        return EthAddress.of(ByteUtil.EMPTY_BYTE_ARRAY);
    }

    public boolean isEmpty() {
        return Arrays.equals(this.address, ByteUtil.EMPTY_BYTE_ARRAY);
    }
}

