/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import java.util.Arrays;
import org.spongycastle.util.encoders.Hex;

public class EthData {
    public final byte[] data;

    private EthData(byte[] data) {
        this.data = data;
    }

    public static EthData of(byte[] data) {
        return new EthData(data);
    }

    public static EthData of(String data) {
        if (data != null && data.startsWith("0x")) {
            return EthData.of(Hex.decode((String)data.substring(2)));
        }
        return EthData.of(Hex.decode((String)data));
    }

    public String withLeading0x() {
        return "0x" + this.toString();
    }

    public String toString() {
        return Hex.toHexString((byte[])this.data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthData ethData = (EthData)o;
        return Arrays.equals(this.data, ethData.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public static EthData empty() {
        return EthData.of(new byte[0]);
    }
}

