/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.EthereumContractInvocationHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.values.EthValue;

public class Payable<T> {
    private final SmartContract contract;
    private final String methodName;
    private final Object[] arguments;
    private final Method method;
    private final EthereumContractInvocationHandler ethereumContractInvocationHandler;

    public Payable(SmartContract contract, String methodName, Object[] arguments, Method method, EthereumContractInvocationHandler ethereumContractInvocationHandler) {
        this.contract = contract;
        this.methodName = methodName;
        this.arguments = arguments;
        this.method = method;
        this.ethereumContractInvocationHandler = ethereumContractInvocationHandler;
    }

    public CompletableFuture<T> with(EthValue value) {
        return this.contract.callFunction(this.methodName, value, this.arguments).thenApply(result -> this.ethereumContractInvocationHandler.convertResult((Object[])result, this.method));
    }
}

