/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.values;

import com.google.common.base.Charsets;
import java.util.Optional;
import org.adridadou.ethereum.swarm.SwarmHash;
import org.adridadou.ethereum.values.SwarmMetadaLink;
import org.adridadou.exception.EthereumApiException;
import org.spongycastle.util.encoders.Hex;

public class SmartContractByteCode {
    private final byte[] code;

    public SmartContractByteCode(byte[] code) {
        this.code = code;
    }

    public static SmartContractByteCode of(byte[] code) {
        return new SmartContractByteCode(code);
    }

    public static SmartContractByteCode of(String code) {
        return new SmartContractByteCode(Hex.decode((String)code));
    }

    public Optional<SwarmMetadaLink> getMetadaLink() {
        if (this.code.length == 0) {
            return Optional.empty();
        }
        byte length1 = this.code[this.code.length - 1];
        byte length2 = this.code[this.code.length - 2];
        int length = length1 + length2 * 256;
        if (length < this.code.length) {
            byte[] link = new byte[length];
            System.arraycopy(this.code, this.code.length - length, link, 0, length);
            return Optional.of(this.toMetaDataLink(link));
        }
        return Optional.empty();
    }

    private SwarmMetadaLink toMetaDataLink(byte[] link) {
        String strLink = new String(link, Charsets.UTF_8);
        if (strLink.startsWith("bzzr0")) {
            return this.toSwarmMetadataLink(link);
        }
        throw new EthereumApiException("unknown protocol forNetwork " + strLink);
    }

    private SwarmMetadaLink toSwarmMetadataLink(byte[] link) {
        byte[] hash = new byte[32];
        System.arraycopy(link, 7, hash, 0, 32);
        return new SwarmMetadaLink(SwarmHash.of(hash));
    }

    public String toString() {
        return Hex.toHexString((byte[])this.code);
    }
}

