/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import java.math.BigInteger;
import org.adridadou.ethereum.BlockchainProxy;
import org.adridadou.ethereum.ContractAbi;
import org.adridadou.ethereum.EthAddress;
import org.adridadou.ethereum.SoliditySource;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractTest;
import org.ethereum.config.BlockchainNetConfig;
import org.ethereum.config.Constants;
import org.ethereum.config.SystemProperties;
import org.ethereum.config.blockchain.FrontierConfig;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.crypto.ECKey;
import org.ethereum.util.blockchain.StandaloneBlockchain;
import rx.Observable;

public class BlockchainProxyTest
implements BlockchainProxy {
    private final StandaloneBlockchain blockchain;

    public BlockchainProxyTest() {
        SystemProperties.getDefault().setBlockchainConfig((BlockchainNetConfig)new FrontierConfig((Constants)new FrontierConfig.FrontierConstants(){

            public BigInteger getMINIMUM_DIFFICULTY() {
                return BigInteger.ONE;
            }
        }));
        this.blockchain = new StandaloneBlockchain();
        this.blockchain.withAutoblock(true);
    }

    @Override
    public SmartContract map(SoliditySource src, String contractName, EthAddress address, ECKey sender) {
        return new SmartContractTest(this.blockchain.createExistingContractFromSrc(src.getSource(), contractName, address.address));
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, ECKey sender) {
        return new SmartContractTest(this.blockchain.createExistingContractFromABI(abi.getAbi(), address.address));
    }

    @Override
    public Observable<EthAddress> publish(SoliditySource code, String contractName, ECKey sender, Object ... constructorArgs) {
        return Observable.just((Object)EthAddress.of(this.blockchain.submitNewContract(code.getSource(), constructorArgs).getAddress()));
    }

    @Override
    public Observable<TransactionReceipt> sendTx(long value, byte[] data, ECKey sender, EthAddress address) {
        return null;
    }

    @Override
    public EthereumEventHandler events() {
        return null;
    }

    @Override
    public boolean addressExists(EthAddress address) {
        return true;
    }
}

