/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import java.util.Arrays;
import org.ethereum.crypto.ECKey;
import org.spongycastle.util.encoders.Hex;

public class EthAddress {
    public final byte[] address;

    private EthAddress(byte[] address) {
        this.address = address;
    }

    public static EthAddress of(byte[] address) {
        return new EthAddress(EthAddress.trimLeft(address));
    }

    public static EthAddress of(ECKey key) {
        return new EthAddress(EthAddress.trimLeft(key.getAddress()));
    }

    private static byte[] trimLeft(byte[] address) {
        int firstNonZeroPos;
        for (firstNonZeroPos = 0; firstNonZeroPos < address.length && address[firstNonZeroPos] == 0; ++firstNonZeroPos) {
        }
        byte[] newAddress = new byte[address.length - firstNonZeroPos];
        System.arraycopy(address, firstNonZeroPos, newAddress, 0, address.length - firstNonZeroPos);
        return newAddress;
    }

    public static EthAddress of(String address) {
        return EthAddress.of(Hex.decode((String)address));
    }

    public String toString() {
        return Hex.toHexString((byte[])this.address);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EthAddress that = (EthAddress)o;
        return Arrays.equals(this.address, that.address);
    }

    public int hashCode() {
        return Arrays.hashCode(this.address);
    }
}

