/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import org.adridadou.ethereum.BlockchainProxy;
import org.adridadou.ethereum.ContractAbi;
import org.adridadou.ethereum.EthAddress;
import org.adridadou.ethereum.EthereumContractInvocationHandler;
import org.adridadou.ethereum.SoliditySource;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.ethereum.crypto.ECKey;
import rx.Observable;

public class EthereumFacade {
    public static final Charset CHARSET = Charsets.UTF_8;
    private final EthereumContractInvocationHandler handler;
    private final BlockchainProxy blockchainProxy;

    public EthereumFacade(BlockchainProxy blockchainProxy) {
        this.handler = new EthereumContractInvocationHandler(blockchainProxy);
        this.blockchainProxy = blockchainProxy;
    }

    public <T> T createContractProxy(SoliditySource code, String contractName, EthAddress address, ECKey sender, Class<T> contractInterface) throws IOException {
        Object proxy = Proxy.newProxyInstance(contractInterface.getClassLoader(), new Class[]{contractInterface}, (InvocationHandler)this.handler);
        this.handler.register(proxy, contractInterface, code, contractName, address, sender);
        return (T)proxy;
    }

    public <T> T createContractProxy(ContractAbi abi, EthAddress address, ECKey sender, Class<T> contractInterface) throws IOException {
        Object proxy = Proxy.newProxyInstance(contractInterface.getClassLoader(), new Class[]{contractInterface}, (InvocationHandler)this.handler);
        this.handler.register(proxy, contractInterface, abi, address, sender);
        return (T)proxy;
    }

    public Observable<EthAddress> publishContract(SoliditySource code, String contractName, ECKey sender, Object ... constructorArgs) {
        return this.blockchainProxy.publish(code, contractName, sender, constructorArgs);
    }

    public boolean addressExists(EthAddress address) {
        return this.blockchainProxy.addressExists(address);
    }

    public EthereumEventHandler events() {
        return this.blockchainProxy.events();
    }
}

