/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.ethereumj.config;

import com.typesafe.config.ConfigFactory;
import java.util.List;
import org.adridadou.ethereum.ethereumj.config.BootNodeConfig;
import org.adridadou.ethereum.ethereumj.config.CacheConfig;
import org.adridadou.ethereum.ethereumj.config.DatabaseConfig;
import org.adridadou.ethereum.ethereumj.config.EthereumJConfig;
import org.adridadou.ethereum.ethereumj.config.MinerOptions;
import org.adridadou.ethereum.ethereumj.config.PeerConfig;
import org.adridadou.ethereum.ethereumj.config.PeerDiscoveryConfig;
import org.adridadou.ethereum.ethereumj.config.SolidityCompilerConfig;
import org.adridadou.ethereum.ethereumj.config.SynchronizationConfig;
import org.adridadou.ethereum.ethereumj.config.TrustedNode;
import org.adridadou.ethereum.ethereumj.config.VmConfig;
import org.ethereum.config.SystemProperties;

public class Config {
    private final SolidityCompilerConfig solc;
    private final MinerOptions minerOptions;
    private final SynchronizationConfig sync;
    private final CacheConfig cache;
    private final List<TrustedNode> trustedNodes;
    private final List<BootNodeConfig> bootNodeConfig;
    private final DatabaseConfig databaseConfig;
    private final PeerConfig peerConfig;
    private final PeerDiscoveryConfig peerDiscoveryConfig;
    private final VmConfig vmConfig;
    private final EthereumJConfig ethereumJConfig;

    public Config(SolidityCompilerConfig solc, MinerOptions minerOptions, SynchronizationConfig sync, CacheConfig cache, List<TrustedNode> trustedNodes, List<BootNodeConfig> bootNodeConfig, DatabaseConfig databaseConfig, PeerConfig peerConfig, PeerDiscoveryConfig peerDiscoveryConfig, VmConfig vmConfig, EthereumJConfig ethereumJConfig) {
        this.solc = solc;
        this.minerOptions = minerOptions;
        this.sync = sync;
        this.cache = cache;
        this.trustedNodes = trustedNodes;
        this.bootNodeConfig = bootNodeConfig;
        this.databaseConfig = databaseConfig;
        this.peerConfig = peerConfig;
        this.peerDiscoveryConfig = peerDiscoveryConfig;
        this.vmConfig = vmConfig;
        this.ethereumJConfig = ethereumJConfig;
    }

    public String toString() {
        return "solc=" + this.solc + ", minerOptions=" + this.minerOptions + ", sync=" + this.sync + ", cache=" + this.cache + ", trustedNodes=" + this.trustedNodes + ", bootNodeConfig=" + this.bootNodeConfig + ", databaseConfig=" + this.databaseConfig + ", peerConfig=" + this.peerConfig + ", vmConfig=" + this.vmConfig + ", ethereumJConfig=" + this.ethereumJConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SolidityCompilerConfig solc;
        private MinerOptions minerOptions;
        private SynchronizationConfig sync;
        private CacheConfig cache;
        private List<TrustedNode> trustedNodes;
        private List<BootNodeConfig> bootNodeConfig;
        private DatabaseConfig databaseConfig;
        private PeerConfig peerConfig;
        private PeerDiscoveryConfig peerDiscoveryConfig;
        private VmConfig vmConfig;
        private EthereumJConfig ethereumJConfig;

        public Builder solc(SolidityCompilerConfig solc) {
            this.solc = solc;
            return this;
        }

        public Builder minerOptions(MinerOptions minerOptions) {
            this.minerOptions = minerOptions;
            return this;
        }

        public Builder sync(SynchronizationConfig sync) {
            this.sync = sync;
            return this;
        }

        public Builder cache(CacheConfig cache) {
            this.cache = cache;
            return this;
        }

        public Builder trustedNodes(List<TrustedNode> trustedNodes) {
            this.trustedNodes = trustedNodes;
            return this;
        }

        public Builder bootNodeConfig(List<BootNodeConfig> bootNodeConfig) {
            this.bootNodeConfig = bootNodeConfig;
            return this;
        }

        public Builder databaseConfig(DatabaseConfig databaseConfig) {
            this.databaseConfig = databaseConfig;
            return this;
        }

        public Builder peerConfig(PeerConfig peerConfig) {
            this.peerConfig = peerConfig;
            return this;
        }

        public Builder peerDiscoveryConfig(PeerDiscoveryConfig peerDiscoveryConfig) {
            this.peerDiscoveryConfig = peerDiscoveryConfig;
            return this;
        }

        public Builder vmConfig(VmConfig vmConfig) {
            this.vmConfig = vmConfig;
            return this;
        }

        public Builder ethereumJConfig(EthereumJConfig ethereumJConfig) {
            this.ethereumJConfig = ethereumJConfig;
            return this;
        }

        public Config build() {
            return new Config(this.solc, this.minerOptions, this.sync, this.cache, this.trustedNodes, this.bootNodeConfig, this.databaseConfig, this.peerConfig, this.peerDiscoveryConfig, this.vmConfig, this.ethereumJConfig);
        }

        public SystemProperties asSystemProperties() {
            SystemProperties props = new SystemProperties();
            props.overrideParams(ConfigFactory.parseString((String)this.build().toString()));
            return props;
        }
    }
}

