/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.ethereumj.config;

import java.util.Optional;

public class VmConfig {
    private final Boolean trace;
    private final String dir;
    private final Boolean compressed;
    private final Integer initStorageLimit;

    public VmConfig(Boolean trace, String dir, Boolean compressed, Integer initStorageLimit) {
        this.trace = trace;
        this.dir = dir;
        this.compressed = compressed;
        this.initStorageLimit = initStorageLimit;
    }

    public String toString() {
        return "{" + Optional.ofNullable(this.trace).map(t -> "\ntrace = " + t).orElse("") + Optional.ofNullable(this.dir).map(d -> "\ndir = '" + d + '\'').orElse("") + Optional.ofNullable(this.compressed).map(c -> "\ncompressed = " + c).orElse("") + Optional.ofNullable(this.initStorageLimit).map(i -> "\ninitStorageLimit = " + i).orElse("") + "\n}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean trace;
        private String dir;
        private Boolean compressed;
        private Integer initStorageLimit;

        public Builder trace(Boolean trace) {
            this.trace = trace;
            return this;
        }

        public Builder dir(String dir) {
            this.dir = dir;
            return this;
        }

        public Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public Builder initStorageLimit(Integer initStorageLimit) {
            this.initStorageLimit = initStorageLimit;
            return this;
        }

        public VmConfig build() {
            return new VmConfig(this.trace, this.dir, this.compressed, this.initStorageLimit);
        }
    }
}

