/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.handler;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Subscriber;

public class AbstractHandler<T>
implements Observable.OnSubscribe<T> {
    private final Set<Subscriber<? super T>> subscribers = Sets.newConcurrentHashSet();
    public final Observable<T> observable = Observable.create((Observable.OnSubscribe)this);

    public void newBlock(T param) {
        this.removeUnSubscribed();
        this.subscribers.forEach(subscriber -> subscriber.onNext(param));
    }

    public void call(Subscriber<? super T> subscriber) {
        this.subscribers.add(subscriber);
        this.removeUnSubscribed();
    }

    private void removeUnSubscribed() {
        Set unsubscribed = this.subscribers.stream().filter(Subscriber::isUnsubscribed).collect(Collectors.toSet());
        this.subscribers.removeAll(unsubscribed);
    }

    public void onTransaction(T param) {
        this.removeUnSubscribed();
        this.subscribers.forEach(subscriber -> subscriber.onNext(param));
    }
}

