/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.handler;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnBlockParameters;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.handler.OnTransactionParameters;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.Block;
import org.ethereum.core.TransactionExecutionSummary;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.facade.Ethereum;
import org.ethereum.listener.EthereumListener;
import org.ethereum.listener.EthereumListenerAdapter;
import org.spongycastle.util.encoders.Hex;
import rx.Observable;

public class EthereumEventHandler
extends EthereumListenerAdapter {
    private final CompletableFuture<Boolean> futureReady = new CompletableFuture();
    private final Observable<Boolean> ready = Observable.from(this.futureReady);
    private final OnBlockHandler onBlockHandler;
    private OnTransactionHandler onTransactionHandler;
    private long currentBlockNumber;

    public EthereumEventHandler(Ethereum ethereum, OnBlockHandler onBlockHandler, OnTransactionHandler onTransactionHandler) {
        ethereum.addListener((EthereumListener)this);
        this.onBlockHandler = onBlockHandler;
        this.onTransactionHandler = onTransactionHandler;
        this.currentBlockNumber = ethereum.getBlockchain().getBestBlock().getNumber();
    }

    public void onBlock(Block block, List<TransactionReceipt> receipts) {
        this.onBlockHandler.newBlock(new OnBlockParameters(block, receipts));
        this.currentBlockNumber = block.getNumber();
    }

    public void onPendingTransactionUpdate(TransactionReceipt txReceipt, EthereumListener.PendingTransactionState state, Block block) {
        this.onTransactionHandler.onTransaction(new OnTransactionParameters(txReceipt.getTransaction(), state));
    }

    public void onTransactionExecuted(TransactionExecutionSummary summary) {
        this.onTransactionHandler.onTransaction(new OnTransactionParameters(summary.getTransaction(), EthereumListener.PendingTransactionState.INCLUDED));
    }

    public TransactionReceipt checkForErrors(TransactionReceipt receipt) {
        if (receipt.isSuccessful() && receipt.isValid()) {
            return receipt;
        }
        throw new EthereumApiException("error with the transaction " + Hex.toHexString((byte[])receipt.getTransaction().getHash()) + ". error:" + receipt.getError());
    }

    public void onSyncDone() {
        this.futureReady.complete(Boolean.TRUE);
    }

    public Observable<Boolean> onReady() {
        return this.ready;
    }

    public long getCurrentBlockNumber() {
        return this.currentBlockNumber;
    }

    public Observable<OnBlockParameters> observeBlocks() {
        return this.onBlockHandler.observable;
    }

    public Observable<OnTransactionParameters> observeTransactions() {
        return this.onTransactionHandler.observable;
    }
}

