/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.provider;

import com.google.common.collect.Lists;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.adridadou.ethereum.BlockchainProxyReal;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.handler.OnBlockHandler;
import org.adridadou.ethereum.handler.OnTransactionHandler;
import org.adridadou.ethereum.keystore.FileSecureKey;
import org.adridadou.ethereum.keystore.SecureKey;
import org.adridadou.ethereum.provider.EthereumFacadeProvider;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.config.SystemProperties;
import org.ethereum.facade.Ethereum;
import org.ethereum.facade.EthereumFactory;
import org.springframework.context.annotation.Bean;

public class MordenEthereumFacadeProvider
implements EthereumFacadeProvider {
    @Override
    public EthereumFacade create() {
        return this.create(new OnBlockHandler(), new OnTransactionHandler());
    }

    @Override
    public EthereumFacade create(OnBlockHandler onBlockHandler, OnTransactionHandler onTransactionHandler) {
        Ethereum ethereum = EthereumFactory.createEthereum(TestNetConfig.class);
        EthereumEventHandler ethereumListener = new EthereumEventHandler(ethereum, onBlockHandler, onTransactionHandler);
        ethereum.init();
        return new EthereumFacade(new BlockchainProxyReal(ethereum, ethereumListener));
    }

    @Override
    public SecureKey getKey(String id) throws Exception {
        return this.listAvailableKeys().stream().filter(file -> file.getName().equals(id)).findFirst().orElseThrow(() -> {
            String names = this.listAvailableKeys().stream().map(FileSecureKey::getName).reduce((aggregate, name) -> aggregate + "," + name).orElse("");
            return new EthereumApiException("could not find the keyfile " + id + " available:" + names);
        });
    }

    private String getKeystoreFolderPath() {
        String homeDir = System.getProperty("user.home");
        return homeDir + "/Library/Ethereum/testnet/keystore/";
    }

    public List<FileSecureKey> listAvailableKeys() {
        Object[] files = Optional.ofNullable(new File(this.getKeystoreFolderPath()).listFiles()).orElseThrow(() -> new EthereumApiException("cannot find the folder " + this.getKeystoreFolderPath()));
        return Lists.newArrayList((Object[])files).stream().filter(File::isFile).map(FileSecureKey::new).collect(Collectors.toList());
    }

    private static class TestNetConfig {
        private final String mordenConfig = "peer.discovery = {\n\n    # List of the peers to start\n    # the search of the online peers\n    # values: [ip:port, ip:port, ip:port ...]\n    ip.list = [\n        \"94.242.229.4:40404\",\n        \"94.242.229.203:30303\"\n    ]\n}\n\n# Network id\npeer.networkId = 2\n\n# Enable EIP-8\npeer.p2p.eip8 = true\n\n# the folder resources/genesis\n# contains several versions of\n# genesis configuration according\n# to the network the peer will run on\ngenesis = frontier-morden.json\n\n# Blockchain settings (constants and algorithms) which are\n# not described in the genesis file (like MINIMUM_DIFFICULTY or Mining algorithm)\nblockchain.config.name = \"morden\"\n\ndatabase {\n    # place to save physical storage files\n    dir = database-morden\n}\n";

        private TestNetConfig() {
        }

        @Bean
        public SystemProperties systemProperties() {
            SystemProperties props = new SystemProperties();
            props.overrideParams(ConfigFactory.parseString((String)"peer.discovery = {\n\n    # List of the peers to start\n    # the search of the online peers\n    # values: [ip:port, ip:port, ip:port ...]\n    ip.list = [\n        \"94.242.229.4:40404\",\n        \"94.242.229.203:30303\"\n    ]\n}\n\n# Network id\npeer.networkId = 2\n\n# Enable EIP-8\npeer.p2p.eip8 = true\n\n# the folder resources/genesis\n# contains several versions of\n# genesis configuration according\n# to the network the peer will run on\ngenesis = frontier-morden.json\n\n# Blockchain settings (constants and algorithms) which are\n# not described in the genesis file (like MINIMUM_DIFFICULTY or Mining algorithm)\nblockchain.config.name = \"morden\"\n\ndatabase {\n    # place to save physical storage files\n    dir = database-morden\n}\n".replaceAll("'", "\"")));
            return props;
        }
    }
}

