/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.smartcontract;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.util.blockchain.SolidityContract;
import rx.Observable;

public class SmartContractTest
implements SmartContract {
    private final SolidityContract contract;

    public SmartContractTest(SolidityContract contract) {
        this.contract = contract;
    }

    @Override
    public Observable<Object[]> callFunction(String methodName, Object ... arguments) {
        return Observable.just((Object)this.contract.callFunction(methodName, arguments).getReturnValues());
    }

    @Override
    public Object[] callConstFunction(String methodName, Object ... arguments) {
        return this.contract.callConstFunction(methodName, arguments);
    }

    @Override
    public List<CallTransaction.Function> getFunctions() {
        try {
            Field field = this.contract.getClass().getDeclaredField("contract");
            field.setAccessible(true);
            CallTransaction.Contract innerContract = (CallTransaction.Contract)field.get(this.contract);
            return Lists.newArrayList((Object[])innerContract.functions);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new EthereumApiException("error while getting functions list", e);
        }
    }
}

