/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.adridadou.ethereum.BlockchainProxy;
import org.adridadou.ethereum.ContractAbi;
import org.adridadou.ethereum.EthAddress;
import org.adridadou.ethereum.EthereumFacade;
import org.adridadou.ethereum.SoliditySource;
import org.adridadou.ethereum.handler.EthereumEventHandler;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.ethereum.smartcontract.SmartContractReal;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionReceipt;
import org.ethereum.crypto.ECKey;
import org.ethereum.db.ByteArrayWrapper;
import org.ethereum.facade.Ethereum;
import org.ethereum.solidity.compiler.CompilationResult;
import org.ethereum.solidity.compiler.SolidityCompiler;
import org.ethereum.util.ByteUtil;
import org.spongycastle.util.encoders.Hex;

public class BlockchainProxyReal
implements BlockchainProxy {
    private static final long BLOCK_WAIT_LIMIT = 16L;
    private final Ethereum ethereum;
    private final EthereumEventHandler eventHandler;

    public BlockchainProxyReal(Ethereum ethereum, EthereumEventHandler eventHandler) {
        this.ethereum = ethereum;
        this.eventHandler = eventHandler;
        eventHandler.onReady().thenAccept(b -> ethereum.getBlockchain().flush());
    }

    @Override
    public SmartContract map(SoliditySource src, String contractName, EthAddress address, ECKey sender) {
        try {
            CompilationResult.ContractMetadata metadata = this.compile(src, contractName);
            return this.mapFromAbi(new ContractAbi(metadata.abi), address, sender);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while mapping a smart contract", e);
        }
    }

    @Override
    public SmartContract mapFromAbi(ContractAbi abi, EthAddress address, ECKey sender) {
        return new SmartContractReal(abi.getAbi(), this.ethereum, sender, address, this);
    }

    @Override
    public CompletableFuture<EthAddress> publish(SoliditySource code, String contractName, ECKey sender, Object ... constructorArgs) {
        try {
            return this.createContract(code, contractName, sender, constructorArgs).thenApply(SmartContractReal::getAddress);
        }
        catch (IOException e) {
            throw new EthereumApiException("error while publishing " + contractName + ":", e);
        }
    }

    private CompletableFuture<SmartContractReal> createContract(SoliditySource soliditySrc, String contractName, ECKey sender, Object ... constructorArgs) throws IOException {
        CompilationResult.ContractMetadata metadata = this.compile(soliditySrc, contractName);
        CallTransaction.Contract contract = new CallTransaction.Contract(metadata.abi);
        CallTransaction.Function constructor = contract.getConstructor();
        if (constructor == null && constructorArgs.length > 0) {
            throw new EthereumApiException("No constructor with params found");
        }
        byte[] argsEncoded = constructor == null ? new byte[]{} : constructor.encodeArguments(constructorArgs);
        return ((CompletableFuture)this.sendTx(1L, ByteUtil.merge((byte[][])new byte[][]{Hex.decode((String)metadata.bin), argsEncoded}), sender, null).thenApply(receipt -> EthAddress.of(receipt.getTransaction().getContractAddress()))).thenApply(address -> new SmartContractReal(contractMetadata.abi, this.ethereum, sender, (EthAddress)address, this));
    }

    private CompilationResult.ContractMetadata compile(SoliditySource src, String contractName) throws IOException {
        SolidityCompiler.Result result = SolidityCompiler.compile((byte[])src.getSource().getBytes(EthereumFacade.CHARSET), (boolean)true, (SolidityCompiler.Options[])new SolidityCompiler.Options[]{SolidityCompiler.Options.ABI, SolidityCompiler.Options.BIN});
        if (result.isFailed()) {
            throw new EthereumApiException("Contract compilation failed:\n" + result.errors);
        }
        CompilationResult res = CompilationResult.parse((String)result.output);
        if (res.contracts.isEmpty()) {
            throw new EthereumApiException("Compilation failed, no contracts returned:\n" + result.errors);
        }
        CompilationResult.ContractMetadata metadata = (CompilationResult.ContractMetadata)res.contracts.get(contractName);
        if (metadata != null && (metadata.bin == null || metadata.bin.isEmpty())) {
            throw new EthereumApiException("Compilation failed, no binary returned:\n" + result.errors);
        }
        return metadata;
    }

    @Override
    public CompletableFuture<TransactionReceipt> sendTx(long value, byte[] data, ECKey sender, EthAddress toAddress) {
        return this.eventHandler.onReady().thenCompose(b -> {
            BigInteger nonce = this.ethereum.getRepository().getNonce(sender.getAddress());
            Transaction tx = new Transaction(ByteUtil.bigIntegerToBytes((BigInteger)nonce), ByteUtil.longToBytesNoLeadZeroes((long)this.ethereum.getGasPrice()), ByteUtil.longToBytesNoLeadZeroes((long)3000000L), toAddress == null ? null : ethAddress.address, ByteUtil.longToBytesNoLeadZeroes((long)value), data);
            tx.sign(sender);
            this.ethereum.submitTransaction(tx);
            long currentBlock = this.eventHandler.getCurrentBlockNumber();
            Predicate<TransactionReceipt> findReceipt = receipt -> new ByteArrayWrapper(receipt.getTransaction().getHash()).equals((Object)new ByteArrayWrapper(tx.getHash()));
            return CompletableFuture.supplyAsync(() -> (TransactionReceipt)this.eventHandler.observeBlocks().filter(params -> params.receipts.stream().anyMatch(findReceipt) || params.block.getNumber() > currentBlock + 16L).map(params -> {
                Optional receipt = params.receipts.stream().filter(findReceipt).findFirst();
                return receipt.map(this.eventHandler::checkForErrors).orElseThrow(() -> new EthereumApiException("the transaction has not been added to any block after waiting for 16"));
            }).toBlocking().first());
        });
    }

    @Override
    public EthereumEventHandler events() {
        return this.eventHandler;
    }

    @Override
    public boolean addressExists(EthAddress address) {
        return this.ethereum.getRepository().isExist(address.address);
    }
}

