/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.ethereumj.config;

import java.util.Set;
import org.adridadou.ethereum.ethereumj.config.HostAddress;
import org.adridadou.ethereum.ethereumj.config.IpAddress;

public class PeerDiscoveryConfig {
    private final Boolean includeHomeNode;
    private final IpAddress ipAddress;
    private final IpAddress externalIpAddress;
    private final Integer touchMaxNodes;
    private final Integer touchPeriod;
    private final Boolean persist;
    private final Set<HostAddress> peersList;
    private final Integer workers;
    private final Boolean enabled;

    public PeerDiscoveryConfig(Boolean includeHomeNode, IpAddress ipAddress, IpAddress externalIpAddress, Integer touchMaxNodes, Integer touchPeriod, Boolean persist, Set<HostAddress> peersList, Integer workers, Boolean enabled) {
        this.includeHomeNode = includeHomeNode;
        this.ipAddress = ipAddress;
        this.externalIpAddress = externalIpAddress;
        this.touchMaxNodes = touchMaxNodes;
        this.touchPeriod = touchPeriod;
        this.persist = persist;
        this.peersList = peersList;
        this.workers = workers;
        this.enabled = enabled;
    }

    public String toString() {
        return "PeerDiscoveryConfig{includeHomeNode=" + this.includeHomeNode + "ipAddress=" + this.ipAddress + "externalIpAddress=" + this.externalIpAddress + "touchMaxNodes=" + this.touchMaxNodes + "touchPeriod=" + this.touchPeriod + "persist=" + this.persist + "peersList=" + this.peersList + "workers=" + this.workers + "enabled=" + this.enabled + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Boolean includeHomeNode;
        private IpAddress ipAddress;
        private IpAddress externalIpAddress;
        private Integer touchMaxNodes;
        private Integer touchPeriod;
        private Boolean persist;
        private Set<HostAddress> peersList;
        private Integer workers;
        private Boolean enabled;

        public Builder includeHomeNode(boolean includeHomeNode) {
            this.includeHomeNode = includeHomeNode;
            return this;
        }

        public Builder ipAddress(IpAddress ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder externalIpAddress(IpAddress externalIpAddress) {
            this.externalIpAddress = externalIpAddress;
            return this;
        }

        public Builder touchMaxNodes(int touchMaxNodes) {
            this.touchMaxNodes = touchMaxNodes;
            return this;
        }

        public Builder touchPeriod(int touchPeriod) {
            this.touchPeriod = touchPeriod;
            return this;
        }

        public Builder persist(boolean persist) {
            this.persist = persist;
            return this;
        }

        public Builder peersList(Set<HostAddress> peersList) {
            this.peersList = peersList;
            return this;
        }

        public Builder workers(int workers) {
            this.workers = workers;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PeerDiscoveryConfig build() {
            return new PeerDiscoveryConfig(this.includeHomeNode, this.ipAddress, this.externalIpAddress, this.touchMaxNodes, this.touchPeriod, this.persist, this.peersList, this.workers, this.enabled);
        }
    }
}

