/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.ethereumj.config;

import java.util.Optional;

public class TrustedNode {
    private final String nodeId;
    private final String ip;

    public TrustedNode(String nodeId, String ip) {
        this.nodeId = nodeId;
        this.ip = ip;
    }

    public String toString() {
        Optional<String> optNodeId = Optional.ofNullable(this.nodeId);
        Optional<String> optIp = Optional.ofNullable(this.ip);
        if (optNodeId.isPresent() || optIp.isPresent()) {
            return "{" + Optional.ofNullable(this.nodeId).map(id -> "\nnodeId='" + this.nodeId + '\'').orElse("") + Optional.ofNullable(this.ip).map(ip -> "\nip='" + ip + '\'').orElse("") + "\n}";
        }
        return "";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String nodeId;
        private String ip;

        public Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public TrustedNode build() {
            return new TrustedNode(this.nodeId, this.ip);
        }
    }
}

