/*
 * Decompiled with CFR 0.152.
 */
package org.adridadou.ethereum.smartcontract;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.adridadou.ethereum.BlockchainProxyReal;
import org.adridadou.ethereum.EthAddress;
import org.adridadou.ethereum.smartcontract.SmartContract;
import org.adridadou.exception.EthereumApiException;
import org.ethereum.core.Block;
import org.ethereum.core.BlockchainImpl;
import org.ethereum.core.CallTransaction;
import org.ethereum.core.Repository;
import org.ethereum.core.Transaction;
import org.ethereum.core.TransactionExecutor;
import org.ethereum.crypto.ECKey;
import org.ethereum.facade.Ethereum;

public class SmartContractReal
implements SmartContract {
    private EthAddress address;
    private CallTransaction.Contract contract;
    private final Ethereum ethereum;
    private final BlockchainProxyReal bcProxy;
    private final ECKey sender;

    public SmartContractReal(String abi, Ethereum ethereum, ECKey sender, EthAddress address, BlockchainProxyReal bcProxy) {
        this.contract = new CallTransaction.Contract(abi);
        this.ethereum = ethereum;
        this.sender = sender;
        this.bcProxy = bcProxy;
        this.address = address;
    }

    @Override
    public List<CallTransaction.Function> getFunctions() {
        return Lists.newArrayList((Object[])this.contract.functions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callConstFunction(Block callBlock, String functionName, Object ... args) {
        Transaction tx = CallTransaction.createCallTransaction((long)0L, (long)0L, (long)100000000000000L, (String)this.address.toString(), (long)0L, (CallTransaction.Function)this.contract.getByName(functionName), (Object[])args);
        tx.sign(this.sender);
        Repository repository = this.getRepository().getSnapshotTo(callBlock.getStateRoot()).startTracking();
        try {
            TransactionExecutor executor = new TransactionExecutor(tx, callBlock.getCoinbase(), repository, this.getBlockchain().getBlockStore(), this.getBlockchain().getProgramInvokeFactory(), callBlock).setLocalCall(true);
            executor.init();
            executor.execute();
            executor.go();
            executor.finalization();
            Object[] objectArray = this.contract.getByName(functionName).decodeResult(executor.getResult().getHReturn());
            return objectArray;
        }
        finally {
            repository.rollback();
        }
    }

    private BlockchainImpl getBlockchain() {
        return (BlockchainImpl)this.ethereum.getBlockchain();
    }

    private Repository getRepository() {
        return this.getBlockchain().getRepository();
    }

    @Override
    public CompletableFuture<Object[]> callFunction(String functionName, Object ... args) {
        return this.callFunction(1L, functionName, args);
    }

    public CompletableFuture<Object[]> callFunction(long value, String functionName, Object ... args) {
        CallTransaction.Function func = this.contract.getByName(functionName);
        if (func == null) {
            throw new EthereumApiException("function " + functionName + " cannot be found. available:" + this.getAvailableFunctions());
        }
        byte[] functionCallBytes = func.encode(args);
        return this.bcProxy.sendTx(value, functionCallBytes, this.sender, this.address).thenApply(receipt -> this.contract.getByName(functionName).decodeResult(receipt.getExecutionResult()));
    }

    private String getAvailableFunctions() {
        ArrayList<String> names = new ArrayList<String>();
        for (CallTransaction.Function func : this.contract.functions) {
            names.add(func.name);
        }
        return ((Object)names).toString();
    }

    @Override
    public Object[] callConstFunction(String functionName, Object ... args) {
        return this.callConstFunction(this.getBlockchain().getBestBlock(), functionName, args);
    }

    public EthAddress getAddress() {
        return this.address;
    }
}

