/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.util;

import java.util.logging.Logger;

public final class Base64Util {
    private static final Logger log;
    private static final char[] CHARS;
    private static final int[] BYTES;

    private Base64Util() {
    }

    public static String encodeBase64(String plainText) {
        char[] chars = Base64Util.encode(plainText);
        return new String(chars);
    }

    public static String encodeBase64(byte[] bytes) {
        char[] chars = Base64Util.encode(bytes);
        return new String(chars);
    }

    public static char[] encode(String plainText) {
        char[] chars = Base64Util.encode(plainText.getBytes());
        return chars;
    }

    public static char[] encode(byte[] bytes) {
        int size = bytes.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = bytes[i++];
            byte b1 = i < size ? bytes[i++] : (byte)0;
            byte b2 = i < size ? bytes[i++] : (byte)0;
            int mask = 63;
            ar[a++] = CHARS[b0 >> 2 & mask];
            ar[a++] = CHARS[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = CHARS[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = CHARS[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return ar;
    }

    public static String decodeBase64(String encodedText) {
        byte[] bytes = Base64Util.decode(encodedText.toCharArray());
        return new String(bytes);
    }

    public static String decodeBase64(char[] encodedChars) {
        byte[] bytes = Base64Util.decode(encodedChars);
        return new String(bytes);
    }

    public static byte[] decode(String encodedText) {
        return Base64Util.decode(encodedText.toCharArray());
    }

    public static byte[] decode(char[] encodedChars) {
        int len = encodedChars.length;
        int delta = len >= 2 && encodedChars[len - 1] == '=' && encodedChars[len - 2] == '=' ? 2 : (len >= 1 && encodedChars[len - 1] == '=' ? 1 : 0);
        byte[] bytes = new byte[len * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < len; i += 4) {
            int c0 = BYTES[encodedChars[i]];
            int c1 = BYTES[encodedChars[i + 1]];
            bytes[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= bytes.length) {
                return bytes;
            }
            int c2 = BYTES[encodedChars[i + 2]];
            bytes[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= bytes.length) {
                return bytes;
            }
            int c3 = BYTES[encodedChars[i + 3]];
            bytes[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return bytes;
    }

    public static char[] encode(byte[] bytes, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = bytes[ip++] & 0xFF;
            int i1 = ip < iEnd ? bytes[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? bytes[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = CHARS[o0];
            out[op++] = CHARS[o1];
            out[op] = op < oDataLen ? CHARS[o2] : 61;
            int n = ++op < oDataLen ? CHARS[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static byte[] decode(char[] chars, int iOff, int iLen) {
        while (iLen > 0 && chars[iOff + iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            char i0 = chars[ip++];
            char i1 = chars[ip++];
            int i2 = ip < iEnd ? chars[ip++] : 65;
            int i3 = ip < iEnd ? chars[ip++] : 65;
            int b0 = BYTES[i0];
            int b1 = BYTES[i1];
            int b2 = BYTES[i2];
            int b3 = BYTES[i3];
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    static {
        int i;
        log = Logger.getLogger(Base64Util.class.getName());
        CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        BYTES = new int[128];
        for (i = 0; i < BYTES.length; ++i) {
            Base64Util.BYTES[i] = -1;
        }
        for (i = 0; i < CHARS.length; ++i) {
            Base64Util.BYTES[Base64Util.CHARS[i]] = i;
        }
    }
}

