/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.exception.ValidationException;

public final class ParamMapUtil {
    private static final Logger log = Logger.getLogger(ParamMapUtil.class.getName());

    private ParamMapUtil() {
    }

    public static Map<String, Object> convertStringArrayMapToObjectValueMap(Map<String, String[]> inputMap) throws ValidationException {
        if (inputMap == null) {
            return null;
        }
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        for (String key : inputMap.keySet()) {
            String[] vals = inputMap.get(key);
            String val = null;
            if (vals == null || vals.length == 0) {
                val = null;
            } else {
                if (vals.length > 1) {
                    throw new ValidationException("Multiple values are set for key = " + key);
                }
                val = vals[0];
            }
            outputMap.put(key, val);
        }
        return outputMap;
    }

    public static Map<String, Object> convertStringListMapToObjectValueMap(Map<String, List<String>> inputMap) throws ValidationException {
        if (inputMap == null) {
            return null;
        }
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        for (String key : inputMap.keySet()) {
            List<String> vals = inputMap.get(key);
            String val = null;
            if (vals == null || vals.isEmpty()) {
                val = null;
            } else {
                if (vals.size() > 1) {
                    throw new ValidationException("Multiple values are set for key = " + key);
                }
                val = vals.get(0);
            }
            outputMap.put(key, val);
        }
        return outputMap;
    }

    public static Map<String, String[]> convertStringListMapToStringArrayMap(Map<String, List<String>> inputMap) throws ValidationException {
        if (inputMap == null) {
            return null;
        }
        HashMap<String, String[]> outputMap = new HashMap<String, String[]>();
        for (String key : inputMap.keySet()) {
            List<String> vals = inputMap.get(key);
            String[] val = null;
            if (vals == null || vals.isEmpty()) {
                val = null;
            } else {
                if (vals.size() > 1) {
                    throw new ValidationException("Multiple values are set for key = " + key);
                }
                val = new String[]{vals.get(0)};
            }
            outputMap.put(key, val);
        }
        return outputMap;
    }

    public static Map<String, String[]> convertObjectValueMapToStringArrayMap(Map<String, Object> inputMap) throws ValidationException {
        if (inputMap == null) {
            return null;
        }
        HashMap<String, String[]> outputMap = new HashMap<String, String[]>();
        for (String key : inputMap.keySet()) {
            Object obj = inputMap.get(key);
            String[] val = null;
            if (obj == null) {
                val = null;
            } else {
                try {
                    val = new String[]{obj.toString()};
                }
                catch (Exception e) {
                    throw new ValidationException("Failed to convert to String[] for key = " + key, e);
                }
            }
            outputMap.put(key, val);
        }
        return outputMap;
    }

    public static Map<String, String> convertObjectValueMapToStringValueMap(Map<String, Object> inputMap) throws ValidationException {
        if (inputMap == null) {
            return null;
        }
        HashMap<String, String> outputMap = new HashMap<String, String>();
        for (String key : inputMap.keySet()) {
            Object obj = inputMap.get(key);
            String val = null;
            if (obj == null) {
                val = null;
            } else {
                try {
                    val = obj.toString();
                }
                catch (Exception e) {
                    throw new ValidationException("Failed to convert the value to String for key = " + key, e);
                }
            }
            outputMap.put(key, val);
        }
        return outputMap;
    }
}

