/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.basic.credential;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.miniauth.credential.TokenCredential;

public final class BasicTokenCredential
implements TokenCredential,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String uname;
    private final String pword;

    public BasicTokenCredential(Map<String, String> authCredential) {
        this(authCredential != null ? authCredential.get("username") : null, authCredential != null ? authCredential.get("password") : null);
    }

    public BasicTokenCredential(String uname, String pword) {
        this.uname = uname;
        this.pword = pword;
    }

    @Override
    public Map<String, String> toReadOnlyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", this.uname);
        map.put("password", this.pword);
        return map;
    }

    @Override
    public String getAccessToken() {
        return this.uname;
    }

    public String getUsername() {
        return this.getAccessToken();
    }

    @Override
    public String getTokenSecret() {
        return this.pword;
    }

    public String getPassword() {
        return this.getTokenSecret();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uname == null ? 0 : this.uname.hashCode());
        result = 31 * result + (this.pword == null ? 0 : this.pword.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicTokenCredential other = (BasicTokenCredential)obj;
        if (this.uname == null ? other.uname != null : !this.uname.equals(other.uname)) {
            return false;
        }
        return !(this.pword == null ? other.pword != null : !this.pword.equals(other.pword));
    }
}

