/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.miniauth.crypto.AbstractSignatureAlgorithm;
import org.miniauth.crypto.SignatureAlgorithm;
import org.miniauth.exception.AuthSignatureException;
import org.miniauth.util.Base64Util;

public class HmacSHA1SignatureAlgorithm
extends AbstractSignatureAlgorithm
implements SignatureAlgorithm {
    @Override
    public String generate(String text, String key) throws AuthSignatureException {
        String signature = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(text.getBytes("UTF-8"));
            signature = Base64Util.encodeBase64(rawHmac);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AuthSignatureException("Failed to generate HMAC.", e);
        }
        return signature;
    }
}

