/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.exception.InternalErrorException;

public final class QueryParamUtil {
    private static final Logger log = Logger.getLogger(QueryParamUtil.class.getName());

    private QueryParamUtil() {
    }

    public static Map<String, String[]> parseQueryParams(String queryString) throws MiniAuthException {
        String[] pairs = queryString.split("&");
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        try {
            for (String p : pairs) {
                String[] pair = p.split("=", 2);
                String key = URLDecoder.decode(pair[0], "UTF-8");
                String val = null;
                val = pair.length > 1 ? URLDecoder.decode(pair[1], "UTF-8") : "";
                if (paramMap.containsKey(key)) {
                    String[] oldArr = (String[])paramMap.get(key);
                    List<String> list = Arrays.asList(oldArr);
                    list.add(val);
                    String[] newArr = list.toArray(new String[0]);
                    paramMap.put(key, newArr);
                    continue;
                }
                paramMap.put(key, new String[]{val});
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("URL decoding error.", e);
        }
        return paramMap;
    }
}

