/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.basic.builder;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.basic.util.BasicAuthorizationValueUtil;
import org.miniauth.builder.AuthStringBuilder;
import org.miniauth.core.AuthScheme;

public class BasicAuthStringBuilder
implements AuthStringBuilder {
    private static final Logger log = Logger.getLogger(BasicAuthStringBuilder.class.getName());

    @Override
    public String generateAuthorizationString(String transmissionType, Map<String, String> authCredential, String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        return this.generateAuthorizationString(transmissionType, authCredential, httpMethod, baseURI, authHeader, null);
    }

    @Override
    public String generateAuthorizationString(String transmissionType, Map<String, String> authCredential, String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        String username = null;
        String password = null;
        if (authCredential != null) {
            if (authCredential.containsKey("username")) {
                username = authCredential.get("username");
            }
            if (authCredential.containsKey("password")) {
                password = authCredential.get("password");
            }
        }
        String paramString = BasicAuthorizationValueUtil.buildBasicAuthorizationValueString(username, password);
        String authString = AuthScheme.getAuthorizationHeaderAuthScheme("Basic") + " " + paramString;
        if (log.isLoggable(Level.FINER)) {
            log.finer("authString = " + authString);
        }
        return authString;
    }
}

