/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.common;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.util.AuthHeaderUtil;
import org.miniauth.util.FormParamUtil;
import org.miniauth.util.QueryParamUtil;

public abstract class RequestBase
implements Serializable {
    private static final Logger log = Logger.getLogger(RequestBase.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String httpMethod = null;
    private volatile URI baseURI = null;
    private Map<String, String> authHeader = null;
    private Map<String, String[]> formParams = null;
    private Map<String, String[]> queryParams = null;

    protected RequestBase() {
        this(null, null);
    }

    protected RequestBase(String httpMethod, URI baseURI) {
        this(httpMethod, baseURI, null, null, null);
    }

    protected RequestBase(String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) {
        this.httpMethod = httpMethod;
        this.baseURI = baseURI;
        this.authHeader = authHeader;
        this.formParams = formParams;
        this.queryParams = queryParams;
    }

    protected RequestBase(RequestBase request) {
        if (request != null) {
            Map<String, String[]> requestQueryParams;
            Map<String, String[]> requestFormParams;
            Map<String, String> requestAuthHeader;
            this.httpMethod = request.getHttpMethod();
            URI targetURI = request.getBaseURI();
            if (targetURI != null) {
                try {
                    this.baseURI = new URI(request.getBaseURI().toString());
                }
                catch (URISyntaxException e) {
                    log.log(Level.WARNING, "Failed to copy baseURI.", e);
                }
            }
            if ((requestAuthHeader = request.getAuthHeader()) != null) {
                this.authHeader = new HashMap<String, String>();
                for (String k : requestAuthHeader.keySet()) {
                    String v = requestAuthHeader.get(k);
                    this.authHeader.put(k, v);
                }
            }
            if ((requestFormParams = request.getFormParams()) != null) {
                this.formParams = new HashMap<String, String[]>();
                for (String k : requestFormParams.keySet()) {
                    String[] values = requestFormParams.get(k);
                    String[] vs = null;
                    if (values != null) {
                        int vLen = values.length;
                        vs = new String[vLen];
                        if (vLen > 0) {
                            System.arraycopy(values, 0, vs, 0, vLen);
                        }
                    }
                    this.formParams.put(k, vs);
                }
            }
            if ((requestQueryParams = request.getQueryParams()) != null) {
                this.queryParams = new HashMap<String, String[]>();
                for (String k : requestQueryParams.keySet()) {
                    String[] values = requestQueryParams.get(k);
                    String[] vs = null;
                    if (values != null) {
                        int vLen = values.length;
                        vs = new String[vLen];
                        if (vLen > 0) {
                            System.arraycopy(values, 0, vs, 0, vLen);
                        }
                    }
                    this.queryParams.put(k, vs);
                }
            }
        }
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    protected RequestBase setHttpMethod(String httpMethod) throws MiniAuthException {
        this.httpMethod = httpMethod;
        return this;
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public URL getBaseURL() {
        if (this.baseURI == null) {
            return null;
        }
        URL url = null;
        try {
            url = this.baseURI.toURL();
        }
        catch (MalformedURLException e) {
            log.log(Level.INFO, "Failed to build URL.", e);
        }
        return url;
    }

    public BaseURIInfo getBaseURIInfo() {
        return new BaseURIInfo(this.baseURI);
    }

    public String getBaseURIString() {
        return this.baseURI == null ? null : this.baseURI.toString();
    }

    public URI getURI() {
        if (this.baseURI == null) {
            return null;
        }
        if (this.queryParams == null || this.queryParams.isEmpty()) {
            return this.baseURI;
        }
        BaseURIInfo uriInfo = new BaseURIInfo(this.baseURI);
        URI uri = null;
        try {
            uri = uriInfo.buildURI(this.queryParams);
        }
        catch (MiniAuthException e) {
            log.log(Level.INFO, "Failed to build URI with queryParams = " + this.queryParams, e);
        }
        return uri;
    }

    public URL getURL() {
        URI uri = this.getURI();
        if (uri == null) {
            return null;
        }
        URL url = null;
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            log.log(Level.INFO, "Failed to build URL with queryParams = " + this.queryParams, e);
        }
        return url;
    }

    public String getURIString() {
        URI uri = this.getURI();
        return uri == null ? null : uri.toString();
    }

    protected RequestBase setBaseURI(URI baseURI) throws MiniAuthException {
        this.baseURI = baseURI;
        return this;
    }

    protected RequestBase setBaseURI(BaseURIInfo uriInfo) throws MiniAuthException {
        this.baseURI = uriInfo == null ? null : uriInfo.buildURI();
        return this;
    }

    protected RequestBase setBaseURI(String baseUri) throws MiniAuthException {
        try {
            this.baseURI = new URI(baseUri);
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException("Invalid baseUri = " + baseUri, e);
        }
        return this;
    }

    public Map<String, String> getAuthHeader() {
        return this.authHeader;
    }

    public String getAuthHeaderString() {
        String authHeaderStr = null;
        try {
            authHeaderStr = AuthHeaderUtil.buildAuthString(this.authHeader);
        }
        catch (MiniAuthException e) {
            log.log(Level.INFO, "Failed to build auth String.", e);
        }
        return authHeaderStr;
    }

    public abstract String getAuthHeaderAuthorizationString();

    protected String getAuthHeaderAuthorizationString(String authScheme) {
        String authorizationString = null;
        String authHeaderStr = this.getAuthHeaderString();
        if (authHeaderStr != null) {
            authorizationString = authScheme + " " + authHeaderStr;
        }
        return authorizationString;
    }

    protected RequestBase setAuthHeader(String authHeader) throws MiniAuthException {
        this.authHeader = AuthHeaderUtil.parseAuthParams(authHeader);
        return this;
    }

    protected RequestBase setAuthHeaderAuthorizationString(String authHeaderAuthString) throws MiniAuthException {
        return this.setAuthHeaderAuthorizationString(authHeaderAuthString, null);
    }

    protected RequestBase setAuthHeaderAuthorizationString(String authHeaderAuthString, String expectedAuthScheme) throws MiniAuthException {
        this.authHeader = AuthHeaderUtil.parseAuthParamsFromAuthorizationString(authHeaderAuthString, expectedAuthScheme);
        return this;
    }

    protected RequestBase setAuthHeader(Map<String, String> authHeader) throws MiniAuthException {
        this.authHeader = authHeader;
        return this;
    }

    protected RequestBase addAuthHeaderParam(String key, String value) throws MiniAuthException {
        if (this.authHeader == null) {
            this.authHeader = new HashMap<String, String>();
        }
        this.authHeader.put(key, value);
        return this;
    }

    public Map<String, String[]> getFormParams() {
        return this.formParams;
    }

    public String getFormParamString() {
        String formParamStr = null;
        try {
            formParamStr = FormParamUtil.buildUrlEncodedFormParamString(this.formParams);
        }
        catch (MiniAuthException e) {
            log.log(Level.INFO, "Failed to build form param String.", e);
        }
        return formParamStr;
    }

    protected RequestBase setFormParams(String formBody) throws MiniAuthException {
        this.formParams = FormParamUtil.parseUrlEncodedFormBody(formBody);
        return this;
    }

    protected RequestBase setFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        this.formParams = formParams;
        return this;
    }

    protected RequestBase addFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        if (this.formParams == null) {
            this.formParams = new HashMap<String, String[]>(formParams);
        } else {
            this.formParams.putAll(formParams);
        }
        return this;
    }

    protected RequestBase addFormParam(String key, String value) throws MiniAuthException {
        String[] values;
        if (this.formParams == null) {
            this.formParams = new HashMap<String, String[]>();
        }
        if ((values = this.formParams.get(key)) == null || values.length == 0) {
            values = new String[]{value};
        } else {
            List<String> list = Arrays.asList(values);
            list.add(value);
            values = list.toArray(EMPTY_STRING_ARRAY);
        }
        this.formParams.put(key, values);
        return this;
    }

    public Map<String, String[]> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryParamString() {
        String queryParamStr = null;
        try {
            queryParamStr = FormParamUtil.buildUrlEncodedFormParamString(this.queryParams);
        }
        catch (MiniAuthException e) {
            log.log(Level.INFO, "Failed to build query param String.", e);
        }
        return queryParamStr;
    }

    protected RequestBase setQueryParams(String queryString) throws MiniAuthException {
        this.queryParams = QueryParamUtil.parseQueryParams(queryString);
        return this;
    }

    protected RequestBase setQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        this.queryParams = queryParams;
        return this;
    }

    protected RequestBase addQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String[]>(queryParams);
        } else {
            this.queryParams.putAll(queryParams);
        }
        return this;
    }

    protected RequestBase addQueryParam(String key, String value) throws MiniAuthException {
        String[] values;
        if (this.queryParams == null) {
            this.queryParams = new HashMap<String, String[]>();
        }
        if ((values = this.queryParams.get(key)) == null || values.length == 0) {
            values = new String[]{value};
        } else {
            List<String> list = Arrays.asList(values);
            list.add(value);
            values = list.toArray(EMPTY_STRING_ARRAY);
        }
        this.queryParams.put(key, values);
        return this;
    }

    public abstract boolean isReady();

    public String toString() {
        return "RequestBase [httpMethod=" + this.httpMethod + ", baseURI=" + this.baseURI + ", authHeader=" + this.authHeader + ", formParams=" + this.formParams + ", queryParams=" + this.queryParams + "]";
    }
}

