/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.common;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.core.UriScheme;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.util.FormParamUtil;

public final class BaseURIInfo {
    private static final Logger log = Logger.getLogger(BaseURIInfo.class.getName());
    private String uriScheme;
    private String userInfo;
    private String host;
    private int port;
    private String path;

    public BaseURIInfo() {
        this(null, null, null, -1, null);
    }

    public BaseURIInfo(URI uri) {
        this(uri == null ? null : uri.getScheme(), uri == null ? null : uri.getUserInfo(), uri == null ? null : uri.getHost(), uri == null ? -1 : uri.getPort(), uri == null ? null : uri.getPath());
    }

    public BaseURIInfo(String uriScheme, String userInfo, String host, int port, String path) {
        this.uriScheme = uriScheme == null ? null : uriScheme.toLowerCase();
        this.userInfo = userInfo == null ? null : userInfo.toLowerCase();
        this.host = host == null ? null : host.toLowerCase();
        this.port = port;
        this.path = path;
    }

    public static BaseURIInfo create(URL url) throws MiniAuthException {
        BaseURIInfo uriInfo = null;
        try {
            uriInfo = new BaseURIInfo(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException("Failed to construrct BaseURIInfo from url = " + url, e);
        }
        return uriInfo;
    }

    public static URI createBaseURI(URL url) throws MiniAuthException {
        URI uri = null;
        try {
            BaseURIInfo uriInfo = new BaseURIInfo(url.toURI());
            uri = uriInfo.buildURI();
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException("Failed to construrct URI from url = " + url, e);
        }
        return uri;
    }

    public String getUriScheme() {
        return this.uriScheme;
    }

    public void setUriScheme(String uriScheme) {
        this.uriScheme = uriScheme == null ? null : uriScheme.toLowerCase();
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo == null ? null : userInfo.toLowerCase();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host == null ? null : host.toLowerCase();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public static String buildBaseURIString(String uriScheme, String userInfo, String host, int port, String path) throws MiniAuthException {
        BaseURIInfo uriInfo = new BaseURIInfo(uriScheme, userInfo, host, port, path);
        return uriInfo.buildURIString();
    }

    public URI buildURI() throws MiniAuthException {
        return this.buildURI(null, null);
    }

    public URI buildURI(String query) throws MiniAuthException {
        return this.buildURI(query, null);
    }

    public URI buildURI(Map<String, String[]> queryParams) throws MiniAuthException {
        String query = FormParamUtil.buildUrlEncodedFormParamString(queryParams);
        return this.buildURI(query, null);
    }

    public URI buildURI(String query, String fragment) throws MiniAuthException {
        int uriPort = this.port;
        if (UriScheme.getDefaultPort(this.uriScheme) == this.port) {
            uriPort = -1;
        }
        URI uri = null;
        try {
            uri = new URI(this.uriScheme, this.userInfo, this.host, uriPort, this.path, query, fragment);
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException("Failed to construrct URI.", e);
        }
        return uri;
    }

    public String buildURIString() throws MiniAuthException {
        return this.buildURIString((String)null);
    }

    public String buildURIString(String query) throws MiniAuthException {
        return this.buildURIString(query, null);
    }

    public String buildURIString(Map<String, String[]> queryParams) throws MiniAuthException {
        return this.buildURIString(queryParams, null);
    }

    public String buildURIString(Map<String, String[]> queryParams, String fragment) throws MiniAuthException {
        String query = FormParamUtil.buildUrlEncodedFormParamString(queryParams);
        return this.buildURIString(query, fragment);
    }

    public String buildURIString(String query, String fragment) throws MiniAuthException {
        URI uri = this.buildURI(query, fragment);
        return uri.toString();
    }

    public URL buildURL() throws MiniAuthException {
        return this.buildURL((String)null);
    }

    public URL buildURL(String query) throws MiniAuthException {
        return this.buildURL(query, null);
    }

    public URL buildURL(Map<String, String[]> queryParams) throws MiniAuthException {
        return this.buildURL(queryParams, null);
    }

    public URL buildURL(Map<String, String[]> queryParams, String fragment) throws MiniAuthException {
        String query = FormParamUtil.buildUrlEncodedFormParamString(queryParams);
        return this.buildURL(query, fragment);
    }

    public URL buildURL(String query, String fragment) throws MiniAuthException {
        URL url = null;
        try {
            URI uri = this.buildURI(query, fragment);
            url = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new InvalidInputException("Failed to construrct URL.", e);
        }
        return url;
    }

    public static URL createURL(URI baseURI, Map<String, String[]> queryParams) throws MiniAuthException {
        return BaseURIInfo.createURL(baseURI, queryParams, null);
    }

    public static URL createURL(URI baseURI, Map<String, String[]> queryParams, String fragment) throws MiniAuthException {
        if (baseURI == null) {
            return null;
        }
        return new BaseURIInfo(baseURI).buildURL(queryParams, fragment);
    }

    public static URL createURL(URI baseURI, String query) throws MiniAuthException {
        return BaseURIInfo.createURL(baseURI, query, null);
    }

    public static URL createURL(URI baseURI, String query, String fragment) throws MiniAuthException {
        if (baseURI == null) {
            return null;
        }
        return new BaseURIInfo(baseURI).buildURL(query, fragment);
    }

    public String toString() {
        String str = "";
        try {
            str = this.buildURIString();
        }
        catch (MiniAuthException e) {
            log.log(Level.WARNING, "Failed to build URI string.", e);
        }
        return str;
    }
}

