/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.common;

import java.net.URI;
import java.util.Map;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.RequestBase;
import org.miniauth.exception.BadRequestException;

public abstract class IncomingRequest
extends RequestBase {
    private static final long serialVersionUID = 1L;
    private boolean ready = false;
    private boolean verified = false;

    protected IncomingRequest() {
    }

    protected IncomingRequest(String httpMethod, URI baseURI) {
        super(httpMethod, baseURI);
    }

    protected IncomingRequest(String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) {
        super(httpMethod, baseURI, authHeader, formParams, queryParams);
    }

    protected IncomingRequest(RequestBase request) {
        super(request);
    }

    @Override
    protected RequestBase setHttpMethod(String httpMethod) throws MiniAuthException {
        super.setHttpMethod(httpMethod);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setBaseURI(URI baseURI) throws MiniAuthException {
        super.setBaseURI(baseURI);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setBaseURI(BaseURIInfo uriInfo) throws MiniAuthException {
        super.setBaseURI(uriInfo);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setBaseURI(String baseUri) throws MiniAuthException {
        super.setBaseURI(baseUri);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setAuthHeader(String authHeader) throws MiniAuthException {
        super.setAuthHeader(authHeader);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setAuthHeaderAuthorizationString(String authHeaderAuthString, String expectedAuthScheme) throws MiniAuthException {
        super.setAuthHeaderAuthorizationString(authHeaderAuthString, expectedAuthScheme);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setAuthHeaderAuthorizationString(String authHeaderAuthString) throws MiniAuthException {
        super.setAuthHeaderAuthorizationString(authHeaderAuthString);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setAuthHeader(Map<String, String> authHeader) throws MiniAuthException {
        super.setAuthHeader(authHeader);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase addAuthHeaderParam(String key, String value) throws MiniAuthException {
        super.addAuthHeaderParam(key, value);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setFormParams(String formBody) throws MiniAuthException {
        super.setFormParams(formBody);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        super.setFormParams(formParams);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase addFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        super.addFormParams(formParams);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase addFormParam(String key, String value) throws MiniAuthException {
        super.addFormParam(key, value);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setQueryParams(String queryString) throws MiniAuthException {
        super.setQueryParams(queryString);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase setQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        super.setQueryParams(queryParams);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase addQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        super.addQueryParams(queryParams);
        this.setVerified(false);
        return this;
    }

    @Override
    protected RequestBase addQueryParam(String key, String value) throws MiniAuthException {
        super.addQueryParam(key, value);
        this.setVerified(false);
        return this;
    }

    public abstract IncomingRequest prepare() throws MiniAuthException;

    public IncomingRequest verify() throws MiniAuthException {
        if (!this.isReady()) {
            throw new BadRequestException("Cannot change the state to verfied because the IncomingRequest is not ready.");
        }
        this.setVerified(true);
        return this;
    }

    @Override
    public boolean isReady() {
        return this.ready;
    }

    protected void setReady(boolean ready) {
        this.ready = ready;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    public abstract boolean isEndorsed() throws MiniAuthException;
}

