/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.exception.InternalErrorException;

public final class FormParamUtil {
    private static final Logger log = Logger.getLogger(FormParamUtil.class.getName());

    private FormParamUtil() {
    }

    public static boolean isUsableForAuth(String contentType, String formBody) {
        return contentType != null && contentType.equals("application/x-www-form-urlencoded");
    }

    public static Map<String, String[]> parseUrlEncodedFormParams(String contentType, String formBody) throws MiniAuthException {
        if (contentType == null || !contentType.equals("application/x-www-form-urlencoded")) {
            return null;
        }
        return FormParamUtil.parseUrlEncodedFormBody(formBody);
    }

    public static Map<String, String[]> parseUrlEncodedFormBody(String formBody) throws MiniAuthException {
        String[] pairs = formBody.split("&");
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        try {
            for (String p : pairs) {
                String[] pair = p.split("=", 2);
                String key = URLDecoder.decode(pair[0], "UTF-8");
                String val = null;
                val = pair.length > 1 ? URLDecoder.decode(pair[1], "UTF-8") : "";
                if (paramMap.containsKey(key)) {
                    String[] oldArr = (String[])paramMap.get(key);
                    List<String> list = Arrays.asList(oldArr);
                    list.add(val);
                    String[] newArr = list.toArray(new String[0]);
                    paramMap.put(key, newArr);
                    continue;
                }
                paramMap.put(key, new String[]{val});
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("URL decoding error.", e);
        }
        return paramMap;
    }

    public static String buildUrlEncodedFormParamString(Map<String, String[]> params) throws MiniAuthException {
        if (params == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            Iterator<String> it = params.keySet().iterator();
            while (it.hasNext()) {
                String k = it.next();
                String encKey = URLEncoder.encode(k, "UTF-8");
                String[] values = params.get(k);
                if (values == null || values.length == 0) {
                    sb.append(encKey);
                } else {
                    for (String v : values) {
                        sb.append(encKey);
                        if (v == null) continue;
                        sb.append("=");
                        if (v.isEmpty()) continue;
                        String encVal = URLEncoder.encode(v, "UTF-8");
                        sb.append(encVal);
                    }
                }
                if (!it.hasNext()) continue;
                sb.append("&");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalErrorException("URL encoding error.", e);
        }
        return sb.toString();
    }
}

