/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.gae.service;

import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.credential.AccessCredential;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.InvalidCredentialException;
import org.miniauth.gae.credential.mapper.GAECredentialMapper;
import org.miniauth.gae.credential.mapper.GAETokenCredentialMapper;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.credential.mapper.OAuthTokenCredentialMapper;
import org.miniauth.oauth.service.OAuthEndorserService;
import org.miniauth.oauth.service.OAuthRequestEndorser;
import org.miniauth.service.EndorserService;

public class OAuthGAEEndorserService
extends OAuthEndorserService
implements EndorserService {
    private static final Logger log = Logger.getLogger(OAuthGAEEndorserService.class.getName());

    public OAuthGAEEndorserService(GAETokenCredentialMapper credentialMapper) {
        super((OAuthTokenCredentialMapper)credentialMapper);
    }

    public GAECredentialMapper getGAECredentialMapper() {
        return (GAECredentialMapper)this.getOAuthCredentialMapper();
    }

    public GAETokenCredentialMapper getGAETokenCredentialMapper() {
        return (GAETokenCredentialMapper)this.getGAECredentialMapper();
    }

    public boolean endorse(OutgoingRequest request) throws MiniAuthException {
        AccessIdentity accessIdentity = ((OAuthOutgoingRequest)request).getAccessIdentity();
        AccessCredential accessCredential = this.getOAuthCredentialMapper().getAccesssCredential(accessIdentity);
        if (accessCredential == null || accessCredential.getTokenSecret() == null) {
            throw new InvalidCredentialException("AccessCredential not found.");
        }
        return OAuthRequestEndorser.getInstance().endorse(accessCredential, request);
    }
}

