/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.common;

import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.BaseURIInfo;
import org.miniauth.common.IncomingRequest;
import org.miniauth.common.RequestBase;
import org.miniauth.credential.AccessIdentity;
import org.miniauth.exception.BadRequestException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.common.OAuthParamMapUtil;
import org.miniauth.oauth.util.ParameterTransmissionUtil;

public class OAuthIncomingRequest
extends IncomingRequest {
    private static final Logger log = Logger.getLogger(OAuthIncomingRequest.class.getName());
    private static final long serialVersionUID = 1L;
    private volatile String authParamTransmissionType = null;
    private OAuthParamMap oauthParamMap = null;

    protected OAuthIncomingRequest() {
        this(null, null);
    }

    protected OAuthIncomingRequest(String httpMethod, URI baseURI) {
        this(httpMethod, baseURI, null, null, null);
    }

    protected OAuthIncomingRequest(String httpMethod, URI baseURI, Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) {
        super(httpMethod, baseURI, authHeader, formParams, queryParams);
    }

    protected OAuthIncomingRequest(RequestBase request) {
        super(request);
    }

    public AccessIdentity getAccessIdentity() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this.oauthParamMap.getAccessIdentity();
    }

    public String getConumserKey() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this.oauthParamMap.getConsumerKey();
    }

    public String getAccessToken() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this.oauthParamMap.getToken();
    }

    protected void initAuthParamTransmissionType() {
        try {
            this.authParamTransmissionType = ParameterTransmissionUtil.getTransmissionType(this.getAuthHeader(), this.getFormParams(), this.getQueryParams());
        }
        catch (MiniAuthException e) {
            log.log(Level.INFO, "Failed to detect authParamTransmissionType.", e);
        }
        if (this.authParamTransmissionType == null) {
            // empty if block
        }
    }

    public String getAuthParamTransmissionType() {
        if (!this.isReady()) {
            this.initAuthParamTransmissionType();
        }
        return this.authParamTransmissionType;
    }

    public void buildOAuthParamMap() throws MiniAuthException {
        this.oauthParamMap = OAuthParamMapUtil.buildOAuthParams(this);
        this.initAuthParamTransmissionType();
        this.setReady(true);
    }

    public OAuthParamMap getOauthParamMap() {
        return this.oauthParamMap;
    }

    public IncomingRequest prepare() throws MiniAuthException {
        this.buildOAuthParamMap();
        return this;
    }

    public IncomingRequest verify() throws MiniAuthException {
        if (!this.isEndorsed()) {
            throw new BadRequestException("Cannot change the state to verfied because the IncomingRequest is not endorsed in the first place.");
        }
        return super.verify();
    }

    public boolean isEndorsed() throws MiniAuthException {
        return this.oauthParamMap != null && this.oauthParamMap.isSignatureSet();
    }

    public String getAuthHeaderAuthorizationString() {
        return this.getAuthHeaderAuthorizationString("OAuth");
    }

    protected RequestBase setHttpMethod(String httpMethod) throws MiniAuthException {
        return super.setHttpMethod(httpMethod);
    }

    protected RequestBase setBaseURI(URI baseURI) throws MiniAuthException {
        return super.setBaseURI(baseURI);
    }

    protected RequestBase setBaseURI(String baseUri) throws MiniAuthException {
        return super.setBaseURI(baseUri);
    }

    protected RequestBase setBaseURI(BaseURIInfo uriInfo) throws MiniAuthException {
        return super.setBaseURI(uriInfo);
    }

    protected RequestBase setAuthHeader(String authHeader) throws MiniAuthException {
        return super.setAuthHeader(authHeader);
    }

    protected RequestBase setAuthHeaderAuthorizationString(String authHeaderAuthString) throws MiniAuthException {
        super.setAuthHeaderAuthorizationString(authHeaderAuthString, "OAuth");
        return this;
    }

    protected RequestBase setAuthHeader(Map<String, String> authHeader) throws MiniAuthException {
        return super.setAuthHeader(authHeader);
    }

    protected RequestBase addAuthHeaderParam(String key, String value) throws MiniAuthException {
        return super.addAuthHeaderParam(key, value);
    }

    protected RequestBase setFormParams(String formBody) throws MiniAuthException {
        return super.setFormParams(formBody);
    }

    protected RequestBase setFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        return super.setFormParams(formParams);
    }

    protected RequestBase addFormParams(Map<String, String[]> formParams) throws MiniAuthException {
        return super.addFormParams(formParams);
    }

    protected RequestBase addFormParam(String key, String value) throws MiniAuthException {
        return super.addFormParam(key, value);
    }

    protected RequestBase setQueryParams(String queryString) throws MiniAuthException {
        return super.setQueryParams(queryString);
    }

    protected RequestBase setQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        return super.setQueryParams(queryParams);
    }

    protected RequestBase addQueryParams(Map<String, String[]> queryParams) throws MiniAuthException {
        return super.addQueryParams(queryParams);
    }

    protected RequestBase addQueryParam(String key, String value) throws MiniAuthException {
        return super.addQueryParam(key, value);
    }

    public String toString() {
        return "OAuthIncomingRequest [authParamTransmissionType=" + this.authParamTransmissionType + ", oauthParamMap=" + this.oauthParamMap + ", getHttpMethod()=" + this.getHttpMethod() + ", getBaseURI()=" + this.getBaseURI() + ", getAuthHeader()=" + this.getAuthHeader() + ", getFormParams()=" + this.getFormParams() + ", getQueryParams()=" + this.getQueryParams() + "]";
    }
}

