/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.credential.AccessCredential;
import org.miniauth.exception.CredentialStoreException;
import org.miniauth.oauth.credential.OAuthAccessCredential;
import org.miniauth.oauth.credential.mapper.AbstractOAuthCredentialMapper;
import org.miniauth.oauth.credential.mapper.DynamicOAuthConsumerCredentialMapper;

public final class OAuthLocalConsumerCredentialMapper
extends AbstractOAuthCredentialMapper
implements DynamicOAuthConsumerCredentialMapper {
    private static final Logger log = Logger.getLogger(OAuthLocalConsumerCredentialMapper.class.getName());
    private final Map<String, String> consumerRegistry = new HashMap<String, String>();

    private OAuthLocalConsumerCredentialMapper() {
    }

    @Override
    protected void init() {
    }

    public static OAuthLocalConsumerCredentialMapper getInstance() {
        return OAuthLocalCredentialMapperHolder.INSTANCE;
    }

    @Override
    public String getConsumerSecret(String consumerKey) throws CredentialStoreException {
        return this.consumerRegistry.get(consumerKey);
    }

    @Override
    public String putConsumerSecret(String consumerKey, String consumerSecret) throws CredentialStoreException {
        return this.consumerRegistry.put(consumerKey, consumerSecret);
    }

    @Override
    public void putConsumerSecrets(Map<String, String> consumerCredentials) throws CredentialStoreException {
        this.consumerRegistry.putAll(consumerCredentials);
    }

    public String getCredentialSecret(String credentialType, String credentialKey) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            return this.consumerRegistry.get(credentialKey);
        }
        return null;
    }

    public String putCredentialSecret(String credentialType, String credentialKey, String credentialSecret) throws CredentialStoreException {
        if ("consumerCredential".equals(credentialType)) {
            return this.consumerRegistry.put(credentialKey, credentialSecret);
        }
        return null;
    }

    @Override
    public AccessCredential getAccesssCredential(String consumerKey) throws CredentialStoreException {
        return new OAuthAccessCredential(this.getConsumerSecret(consumerKey), null);
    }

    @Override
    public AccessCredential putAccesssCredential(String consumerKey, String consumerSecret) throws CredentialStoreException {
        String oldSecret = this.consumerRegistry.put(consumerKey, consumerSecret);
        return new OAuthAccessCredential(oldSecret, null);
    }

    private static final class OAuthLocalCredentialMapperHolder {
        private static final OAuthLocalConsumerCredentialMapper INSTANCE = new OAuthLocalConsumerCredentialMapper();

        private OAuthLocalCredentialMapperHolder() {
        }
    }
}

