/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.service;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.common.OutgoingRequest;
import org.miniauth.credential.AccessCredential;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.exception.InvalidStateException;
import org.miniauth.oauth.common.OAuthOutgoingRequest;
import org.miniauth.oauth.signature.OAuthSignatureGenerator;
import org.miniauth.service.RequestEndorser;
import org.miniauth.signature.SignatureGenerator;

public class OAuthRequestEndorser
implements RequestEndorser {
    private static final Logger log = Logger.getLogger(OAuthRequestEndorser.class.getName());
    private SignatureGenerator signatureGenerator = new OAuthSignatureGenerator();

    private OAuthRequestEndorser() {
    }

    public static OAuthRequestEndorser getInstance() {
        return OAuthRequestEndorserHolder.INSTANCE;
    }

    public boolean endorse(AccessCredential credential, OutgoingRequest request) throws MiniAuthException {
        if (request == null) {
            throw new InvalidInputException("OutgoingRequest is null.");
        }
        if (request.isEndorsed()) {
            throw new InvalidStateException("OutgoingRequest is already endorsed.");
        }
        if (!request.isReady()) {
            throw new InvalidStateException("OutgoingRequest is not ready for endorsement.");
        }
        OAuthOutgoingRequest oauthRequest = (OAuthOutgoingRequest)request;
        Map authCredential = null;
        if (credential != null) {
            authCredential = credential.toReadOnlyMap();
        }
        String signature = this.signatureGenerator.generate(authCredential, oauthRequest.getHttpMethod(), oauthRequest.getBaseURI(), oauthRequest.getAuthHeader(), oauthRequest.getFormParams(), oauthRequest.getQueryParams());
        oauthRequest.endorse(signature);
        if (log.isLoggable(Level.FINE)) {
            log.fine("oauthRequest = " + (Object)((Object)oauthRequest));
        }
        return true;
    }

    private static final class OAuthRequestEndorserHolder {
        private static final OAuthRequestEndorser INSTANCE = new OAuthRequestEndorser();

        private OAuthRequestEndorserHolder() {
        }
    }
}

