/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.exception.ValidationException;
import org.miniauth.oauth.common.OAuthParamMap;
import org.miniauth.oauth.core.OAuthConstants;
import org.miniauth.oauth.core.SignatureMethod;
import org.miniauth.oauth.util.ParameterTransmissionUtil;
import org.miniauth.util.ParamMapUtil;

public final class OAuthSignatureUtil {
    private static final Logger log = Logger.getLogger(OAuthSignatureUtil.class.getName());

    private OAuthSignatureUtil() {
    }

    public static boolean containsAnyOAuthParam(Map<String, String[]> params) throws MiniAuthException {
        if (params == null || params.isEmpty()) {
            return false;
        }
        for (String key : params.keySet()) {
            if (!OAuthConstants.isOAuthParam(key)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getOAuthParams(Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        Map<String, String> params = null;
        if (authHeader != null && !authHeader.isEmpty()) {
            params = authHeader;
        } else if (requestParams != null && requestParams.containsKey("oauth_signature_method")) {
            params = new HashMap<String, String>();
            for (String q : requestParams.keySet()) {
                if (!OAuthConstants.isOAuthParam(q)) continue;
                String[] valArr = requestParams.get(q);
                if (valArr == null || valArr.length != 1) {
                    throw new ValidationException("Multiple values found for the OAuth param: " + q);
                }
                params.put(q, valArr[0]);
            }
        }
        return params;
    }

    public static Map<String, String> getOAuthParams(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, String> params = null;
        String ptType = ParameterTransmissionUtil.getTransmissionType(authHeader, formParams, queryParams);
        if (ptType == null) {
            return authHeader;
        }
        switch (ptType) {
            case "header": {
                params = authHeader;
                break;
            }
            case "form": {
                params = new HashMap<String, String>();
                for (String k : formParams.keySet()) {
                    if (!OAuthConstants.isOAuthParam(k)) continue;
                    String[] valArr = formParams.get(k);
                    if (valArr == null || valArr.length != 1) {
                        throw new ValidationException("Multiple values found for the OAuth param: " + k);
                    }
                    params.put(k, valArr[0]);
                }
                break;
            }
            case "query": {
                params = new HashMap<String, String>();
                for (String q : queryParams.keySet()) {
                    if (!OAuthConstants.isOAuthParam(q)) continue;
                    String[] valArr = queryParams.get(q);
                    if (valArr == null || valArr.length != 1) {
                        throw new ValidationException("Multiple values found for the OAuth param: " + q);
                    }
                    params.put(q, valArr[0]);
                }
                break;
            }
        }
        return params;
    }

    public static String getOAuthSignatureMethod(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        Map<String, String[]> requestParams = OAuthSignatureUtil.mergeRequestParameters(formParams, queryParams);
        return OAuthSignatureUtil.getOAuthSignatureMethod(authHeader, requestParams);
    }

    public static String getOAuthSignatureMethod(Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        Map<String, String> oauthParams = OAuthSignatureUtil.getOAuthParams(authHeader, requestParams);
        return OAuthSignatureUtil.getOAuthSignatureMethod(oauthParams);
    }

    public static String getOAuthSignatureMethod(Map<String, String> oauthParams) throws MiniAuthException {
        String signatureMethod = null;
        if (oauthParams != null) {
            signatureMethod = oauthParams.get("oauth_signature_method");
        }
        return signatureMethod;
    }

    public static OAuthParamMap validateOAuthParams(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        return OAuthSignatureUtil.validateOAuthParams(authHeader, formParams, queryParams, true);
    }

    public static OAuthParamMap validateOAuthParams(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams, boolean signatureRequired) throws MiniAuthException {
        Map<String, String> authParams = OAuthSignatureUtil.getOAuthParams(authHeader, formParams, queryParams);
        return OAuthSignatureUtil.validateOAuthParams(authParams, signatureRequired);
    }

    public static OAuthParamMap validateOAuthParams(Map<String, String> authHeader, Map<String, String[]> requestParams) throws MiniAuthException {
        return OAuthSignatureUtil.validateOAuthParams(authHeader, requestParams, true);
    }

    public static OAuthParamMap validateOAuthParams(Map<String, String> authHeader, Map<String, String[]> requestParams, boolean signatureRequired) throws MiniAuthException {
        Map<String, String> authParams = OAuthSignatureUtil.getOAuthParams(authHeader, requestParams);
        return OAuthSignatureUtil.validateOAuthParams(authParams, signatureRequired);
    }

    public static OAuthParamMap validateOAuthParams(Map<String, String> authParams) throws MiniAuthException {
        return OAuthSignatureUtil.validateOAuthParams(authParams, true);
    }

    public static OAuthParamMap validateOAuthParams(Map<String, String> authParams, boolean signatureRequired) throws MiniAuthException {
        if (authParams == null || authParams.isEmpty()) {
            throw new ValidationException("OAuth param map is null/empty.");
        }
        OAuthParamMap oauthParamMap = new OAuthParamMap();
        if (!authParams.containsKey("oauth_consumer_key")) {
            throw new ValidationException("OAuth consumer key is missing.");
        }
        String consumerKey = authParams.get("oauth_consumer_key");
        if (consumerKey == null || consumerKey.isEmpty()) {
            throw new ValidationException("Invalid OAuth consumer key..");
        }
        oauthParamMap.put("oauth_consumer_key", consumerKey);
        if (authParams.containsKey("oauth_token")) {
            String token = authParams.get("oauth_token");
            if (token == null || token.isEmpty()) {
                throw new ValidationException("Invalid OAuth access token.");
            }
            oauthParamMap.put("oauth_token", token);
        }
        String signatureMethod = null;
        if (!authParams.containsKey("oauth_signature_method")) {
            throw new ValidationException("OAuth signature method is missing.");
        }
        String sigMethod = authParams.get("oauth_signature_method");
        if (sigMethod == null || sigMethod.isEmpty()) {
            throw new ValidationException("OAuth signature method param is invalid.");
        }
        if (!SignatureMethod.isValid(sigMethod)) {
            throw new ValidationException("Invalid OAuth signature method: " + sigMethod);
        }
        signatureMethod = sigMethod;
        oauthParamMap.put("oauth_signature_method", signatureMethod);
        if (SignatureMethod.requiresNonceAndTimestamp(signatureMethod) && !authParams.containsKey("oauth_timestamp")) {
            throw new ValidationException("OAuth timestamp is missing.");
        }
        if (authParams.containsKey("oauth_timestamp")) {
            String timestampStr = authParams.get("oauth_timestamp");
            if (timestampStr == null || timestampStr.isEmpty()) {
                throw new ValidationException("Invalid OAuth timestamp.");
            }
            try {
                int ts = Integer.parseInt(timestampStr);
                if (ts <= 0) {
                    throw new ValidationException("Non-positive OAuth timestamp: " + timestampStr);
                }
                oauthParamMap.put("oauth_timestamp", ts);
            }
            catch (NumberFormatException e) {
                throw new ValidationException("Invalid OAuth timestamp: " + timestampStr, (Throwable)e);
            }
        }
        if (SignatureMethod.requiresNonceAndTimestamp(signatureMethod) && !authParams.containsKey("oauth_nonce")) {
            throw new ValidationException("OAuth nonce is missing.");
        }
        if (authParams.containsKey("oauth_nonce")) {
            String nonce = authParams.get("oauth_nonce");
            if (nonce == null || nonce.isEmpty()) {
                throw new ValidationException("Invalid OAuth nonce.");
            }
            oauthParamMap.put("oauth_nonce", nonce);
        }
        if (authParams.containsKey("oauth_version")) {
            String version = authParams.get("oauth_version");
            if (version == null || !version.equals("1.0")) {
                throw new ValidationException("Invalid OAuth version.");
            }
            oauthParamMap.put("oauth_version", version);
        }
        if (!authParams.containsKey("oauth_signature")) {
            if (signatureRequired) {
                throw new ValidationException("OAuth signature is missing.");
            }
        } else {
            String signature = authParams.get("oauth_signature");
            if (signatureRequired && (signature == null || signature.isEmpty())) {
                throw new ValidationException("Invalid OAuth signature.");
            }
            oauthParamMap.put("oauth_signature", signature);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("oauthParamMap = " + oauthParamMap);
        }
        return oauthParamMap;
    }

    public static String buildOAuthParamString(Map<String, Object> oauthParams) throws MiniAuthException {
        return OAuthSignatureUtil.buildOAuthParamString(new OAuthParamMap(oauthParams));
    }

    public static String buildOAuthParamString(OAuthParamMap oauthParamMap) throws MiniAuthException {
        if (oauthParamMap == null) {
            return null;
        }
        return oauthParamMap.buildUrlEncodedParamString();
    }

    public static Map<String, String[]> mergeRequestParameters(Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        return OAuthSignatureUtil.mergeRequestParameters(null, formParams, queryParams);
    }

    public static Map<String, String[]> mergeRequestParameters(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        String[] values;
        List<String> valueList;
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        if (authHeader != null) {
            for (String key : authHeader.keySet()) {
                String value = authHeader.get(key);
                valueList = new ArrayList<String>();
                valueList.add(value);
                paramMap.put(key, valueList);
            }
        }
        if (formParams != null) {
            for (String key : formParams.keySet()) {
                values = formParams.get(key);
                valueList = (List)paramMap.get(key);
                if (valueList == null) {
                    valueList = new ArrayList();
                    paramMap.put(key, valueList);
                }
                for (String v : values) {
                    valueList.add(v);
                }
            }
        }
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                values = queryParams.get(key);
                valueList = (List)paramMap.get(key);
                if (valueList == null) {
                    valueList = new ArrayList();
                    paramMap.put(key, valueList);
                }
                for (String v : values) {
                    valueList.add(v);
                }
            }
        }
        Map requestParams = ParamMapUtil.convertStringListMapToStringArrayMap(paramMap);
        return requestParams;
    }
}

