/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.util;

import java.util.Map;
import java.util.logging.Logger;
import org.miniauth.MiniAuthException;
import org.miniauth.exception.InvalidInputException;
import org.miniauth.oauth.util.OAuthSignatureUtil;
import org.miniauth.util.AuthHeaderUtil;

public final class ParameterTransmissionUtil {
    private static final Logger log = Logger.getLogger(ParameterTransmissionUtil.class.getName());

    private ParameterTransmissionUtil() {
    }

    public static boolean isTransmissionTypeValid(String type) {
        return "header".equals(type) || "form".equals(type) || "query".equals(type);
    }

    public static String getDefaultTransmissionType() {
        return "header";
    }

    public static String getOAuthParameterTransmissionType(Map<String, String> header, Map<String, String[]> form, Map<String, String[]> query) throws MiniAuthException {
        if (header != null && header.containsKey("Authorization")) {
            String authScheme = AuthHeaderUtil.getAuthScheme(header);
            if ("OAuth".equals(authScheme)) {
                return "header";
            }
            throw new InvalidInputException("Invalid authorization header: authScheme = " + authScheme);
        }
        if (form != null && OAuthSignatureUtil.containsAnyOAuthParam(form)) {
            return "form";
        }
        if (query != null && OAuthSignatureUtil.containsAnyOAuthParam(query)) {
            return "query";
        }
        throw new InvalidInputException("Auth credential not found.");
    }

    public static String getTransmissionType(Map<String, String> authHeader, Map<String, String[]> formParams, Map<String, String[]> queryParams) throws MiniAuthException {
        if (authHeader != null && !authHeader.isEmpty()) {
            return "header";
        }
        if (formParams != null && OAuthSignatureUtil.containsAnyOAuthParam(formParams)) {
            return "form";
        }
        if (queryParams != null && OAuthSignatureUtil.containsAnyOAuthParam(queryParams)) {
            return "query";
        }
        return ParameterTransmissionUtil.getDefaultTransmissionType();
    }
}

