/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.credential;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.miniauth.credential.AccessCredential;

public final class OAuthAccessCredential
implements AccessCredential,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String consumerSecret;
    private final String tokenSecret;

    public OAuthAccessCredential(Map<String, String> authCredential) {
        this(authCredential != null ? authCredential.get("consumerSecret") : null, authCredential != null ? authCredential.get("tokenSecret") : null);
    }

    public OAuthAccessCredential(String consumerSecret, String tokenSecret) {
        this.consumerSecret = consumerSecret;
        this.tokenSecret = tokenSecret;
    }

    public Map<String, String> toReadOnlyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("consumerSecret", this.consumerSecret);
        map.put("tokenSecret", this.tokenSecret);
        return map;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        result = 31 * result + (this.tokenSecret == null ? 0 : this.tokenSecret.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthAccessCredential other = (OAuthAccessCredential)obj;
        if (this.consumerSecret == null ? other.consumerSecret != null : !this.consumerSecret.equals(other.consumerSecret)) {
            return false;
        }
        return !(this.tokenSecret == null ? other.tokenSecret != null : !this.tokenSecret.equals(other.tokenSecret));
    }

    public String toString() {
        return "OAuthAccessCredential [consumerSecret=" + this.consumerSecret + ", tokenSecret=" + this.tokenSecret + "]";
    }
}

