/*
 * Decompiled with CFR 0.152.
 */
package org.miniauth.oauth.crypto;

import java.util.logging.Logger;
import org.miniauth.oauth.core.SignatureMethod;
import org.miniauth.oauth.crypto.HmacSHA1OAuthSignatureAlgorithm;
import org.miniauth.oauth.crypto.OAuthSignatureAlgorithm;
import org.miniauth.oauth.crypto.PlainTextOAuthSignatureAlgorithm;
import org.miniauth.oauth.crypto.RsaSHA1OAuthSignatureAlgorithm;

public class OAuthSignatureAlgorithmFactory {
    private static final Logger log = Logger.getLogger(OAuthSignatureAlgorithmFactory.class.getName());
    private static final HmacSHA1OAuthSignatureAlgorithm sHmacSHA1OAuthSignatureAlgorithm = new HmacSHA1OAuthSignatureAlgorithm();
    private static final RsaSHA1OAuthSignatureAlgorithm sRsaSHA1OAuthSignatureAlgorithm = new RsaSHA1OAuthSignatureAlgorithm();
    private static final PlainTextOAuthSignatureAlgorithm sPlainTextOAuthSignatureAlgorithm = new PlainTextOAuthSignatureAlgorithm();

    private OAuthSignatureAlgorithmFactory() {
    }

    public static OAuthSignatureAlgorithmFactory getInstance() {
        return OAuthSignatureAlgorithmFactoryHolder.INSTANCE;
    }

    public OAuthSignatureAlgorithm getOAuthSignatureAlgorithm(String signatureMethod) {
        if (!SignatureMethod.isValid(signatureMethod)) {
            return null;
        }
        switch (signatureMethod) {
            case "HMAC-SHA1": {
                return sHmacSHA1OAuthSignatureAlgorithm;
            }
            case "RSA-SHA1": {
                return sRsaSHA1OAuthSignatureAlgorithm;
            }
            case "PLAINTEXT": {
                return sPlainTextOAuthSignatureAlgorithm;
            }
        }
        return null;
    }

    private static final class OAuthSignatureAlgorithmFactoryHolder {
        private static final OAuthSignatureAlgorithmFactory INSTANCE = new OAuthSignatureAlgorithmFactory();

        private OAuthSignatureAlgorithmFactoryHolder() {
        }
    }
}

